/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="SLOM: a new measure for local spatial outliers")
@Description(value="Spatial local outlier measure (SLOM), which captures the local behaviour of datum in their spatial neighbourhood")
@Reference(authors="S. Chawla, P. Sun", title="SLOM: a new measure for local spatial outliers", booktitle="Knowledge and Information Systems 9(4)", url="https://doi.org/10.1007/s10115-005-0200-2", bibkey="DBLP:journals/kais/ChawlaS06")
public class SLOM<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    private static final Logging LOG = Logging.getLogger(SLOM.class);

    public SLOM(NeighborSetPredicate.Factory<N> npred, PrimitiveDistanceFunction<O> nonSpatialDistanceFunction) {
        super(npred, nonSpatialDistanceFunction);
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> relation) {
        DBIDs neighbors;
        int cnt;
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        DistanceQuery<O> distFunc = this.getNonSpatialDistanceFunction().instantiate(relation);
        WritableDoubleDataStore modifiedDistance = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double sum = 0.0;
            double maxDist = 0.0;
            cnt = 0;
            neighbors = npred.getNeighborDBIDs(iditer);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer, iter)) {
                    double dist = distFunc.distance((DBIDRef)iditer, (DBIDRef)iter);
                    sum += dist;
                    ++cnt;
                    maxDist = Math.max(maxDist, dist);
                }
                iter.advance();
            }
            if (cnt > 1) {
                modifiedDistance.putDouble(iditer, (sum - maxDist) / (double)(cnt - 1));
            } else {
                modifiedDistance.putDouble(iditer, maxDist);
            }
            iditer.advance();
        }
        DoubleMinMax slomminmax = new DoubleMinMax();
        WritableDoubleDataStore sloms = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double slom;
            double sum = 0.0;
            cnt = 0;
            neighbors = npred.getNeighborDBIDs(iditer2);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer2, iter)) {
                    sum += modifiedDistance.doubleValue(iter);
                    ++cnt;
                }
                iter.advance();
            }
            if (cnt > 0) {
                double avgPlus = (sum + modifiedDistance.doubleValue(iditer2)) / (double)(cnt + 1);
                double avg = sum / (double)cnt;
                double beta = 0.0;
                DBIDIter iter2 = neighbors.iter();
                while (iter2.valid()) {
                    double dist = modifiedDistance.doubleValue(iter2);
                    if (dist > avgPlus) {
                        beta += 1.0;
                    } else if (dist < avgPlus) {
                        beta -= 1.0;
                    }
                    iter2.advance();
                }
                if (!neighbors.contains(iditer2)) {
                    double dist = modifiedDistance.doubleValue(iditer2);
                    if (dist > avgPlus) {
                        beta += 1.0;
                    } else if (dist < avgPlus) {
                        beta -= 1.0;
                    }
                }
                beta = Math.abs(beta);
                beta = cnt > 1 ? Math.max(beta, 1.0) / (double)(cnt - 1) : 1.0;
                slom = (beta /= 1.0 + avg) * modifiedDistance.doubleValue(iditer2);
            } else {
                slom = 0.0;
            }
            sloms.putDouble(iditer2, slom);
            slomminmax.put(slom);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("SLOM", "slom-outlier", sloms, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(slomminmax.getMin(), slomminmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Parameterizer<N, O> {
        @Override
        protected SLOM<N, O> makeInstance() {
            return new SLOM(this.npredf, this.distanceFunction);
        }
    }
}

