/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractDistanceBasedSpatialOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Spatial Outlier Factor")
@Reference(authors="T. Huang, X. Qin", title="Detecting outliers in spatial database", booktitle="Proc. 3rd International Conference on Image and Graphics", url="https://doi.org/10.1109/ICIG.2004.53", bibkey="DBLP:conf/icig/HuangQ04")
public class SOF<N, O>
extends AbstractDistanceBasedSpatialOutlier<N, O> {
    private static final Logging LOG = Logging.getLogger(SOF.class);

    public SOF(NeighborSetPredicate.Factory<N> npred, PrimitiveDistanceFunction<O> nonSpatialDistanceFunction) {
        super(npred, nonSpatialDistanceFunction);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> relation) {
        double lrd;
        double avg;
        DBIDs neighbors;
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        DistanceQuery<O> distFunc = this.getNonSpatialDistanceFunction().instantiate(relation);
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            neighbors = npred.getNeighborDBIDs(iditer);
            avg = 0.0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                avg += distFunc.distance((DBIDRef)iditer, (DBIDRef)iter);
                iter.advance();
            }
            lrd = 1.0 / (avg / (double)neighbors.size());
            if (Double.isNaN(lrd)) {
                lrd = 0.0;
            }
            lrds.putDouble(iditer, lrd);
            iditer.advance();
        }
        iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            neighbors = npred.getNeighborDBIDs(iditer);
            avg = 0.0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                avg += lrds.doubleValue(iter);
                iter.advance();
            }
            lrd = avg / (double)neighbors.size() / lrds.doubleValue(iditer);
            if (!Double.isNaN(lrd)) {
                lofs.putDouble(iditer, lrd);
                lofminmax.put(lrd);
            } else {
                lofs.putDouble(iditer, 0.0);
            }
            iditer.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Spatial Outlier Factor", "sof-outlier", lofs, relation.getDBIDs());
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O>
    extends AbstractDistanceBasedSpatialOutlier.Parameterizer<N, O> {
        @Override
        protected SOF<N, O> makeInstance() {
            return new SOF(this.npredf, this.distanceFunction);
        }
    }
}

