/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="A Trimmed Mean Approach to Finding Spatial Outliers")
@Description(value="A local trimmed mean approach to evaluating the spatial outlier factor which is the degree that a site is outlying compared to its neighbors")
@Reference(authors="T. Hu, S. Y. Sung", title="A trimmed mean approach to finding spatial outliers", booktitle="Intelligent Data Analysis 8", url="http://content.iospress.com/articles/intelligent-data-analysis/ida00153", bibkey="DBLP:journals/ida/HuS04")
public class TrimmedMeanApproach<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(TrimmedMeanApproach.class);
    private double p;

    protected TrimmedMeanApproach(NeighborSetPredicate.Factory<N> npredf, double p) {
        super(npredf);
        this.p = p;
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        assert (RelationUtil.dimensionality(relation) == 1) : "TrimmedMean can only process one-dimensional data sets.";
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore errors = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 1);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Computing trimmed means", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double tm;
            DBIDs neighbors = npred.getNeighborDBIDs(iditer);
            int num = 0;
            double[] values = new double[neighbors.size()];
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                values[num] = relation.get(iter).doubleValue(0);
                ++num;
                iter.advance();
            }
            if (num > 0) {
                int left = (int)Math.floor(this.p * (double)(num - 1));
                int right = (int)Math.floor((1.0 - this.p) * (double)(num - 1));
                Arrays.sort(values, 0, num);
                Mean mean = new Mean();
                for (int i = left; i <= right; ++i) {
                    mean.put(values[i]);
                }
                tm = mean.getMean();
            } else {
                tm = relation.get(iditer).doubleValue(0);
            }
            errors.putDouble(iditer, relation.get(iditer).doubleValue(0) - tm);
            LOG.incrementProcessed(progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isVerbose()) {
            LOG.verbose("Computing median error.");
        }
        double[] ei = new double[relation.size()];
        int i = 0;
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            ei[i] = errors.doubleValue(iditer2);
            ++i;
            iditer2.advance();
        }
        double median_i = QuickSelect.median(ei);
        for (int i2 = 0; i2 < ei.length; ++i2) {
            ei[i2] = Math.abs(ei[i2] - median_i);
        }
        double median_dev_from_median = QuickSelect.median(ei);
        if (LOG.isVerbose()) {
            LOG.verbose("Normalizing scores.");
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            double score = Math.abs(errors.doubleValue(iditer3)) * 0.6745 / median_dev_from_median;
            scores.putDouble(iditer3, score);
            minmax.put(score);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("TrimmedMean", "Trimmed Mean Score", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        public static final OptionID P_ID = new OptionID("tma.p", "the percentile parameter");
        protected double p = 0.2;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter pP = (DoubleParameter)((DoubleParameter)new DoubleParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE);
            if (config.grab(pP)) {
                this.p = (Double)pP.getValue();
            }
        }

        @Override
        protected TrimmedMeanApproach<N> makeInstance() {
            return new TrimmedMeanApproach(this.npredf, this.p);
        }
    }
}

