/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;

public abstract class AbstractPrecomputedNeighborhood
implements NeighborSetPredicate {
    protected DataStore<DBIDs> store;

    public AbstractPrecomputedNeighborhood(DataStore<DBIDs> store) {
        this.store = store;
    }

    @Override
    public DBIDs getNeighborDBIDs(DBIDRef reference) {
        DBIDs neighbors = this.store.get(reference);
        if (neighbors != null) {
            return neighbors;
        }
        if (this.getLogger().isDebugging()) {
            this.getLogger().warning("No neighbors for object " + reference);
        }
        return DBIDUtil.deref(reference);
    }

    protected abstract Logging getLogger();

    public static abstract class Factory<O>
    implements NeighborSetPredicate.Factory<O> {
    }
}

