/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class ExtendedNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(ExtendedNeighborhood.class);

    public ExtendedNeighborhood(DataStore<DBIDs> store) {
        super(store);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Extended Neighborhood";
    }

    @Override
    public String getShortName() {
        return "extended-neighborhood";
    }

    public static class Factory<O>
    extends AbstractPrecomputedNeighborhood.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> inner, int steps) {
            this.inner = inner;
            this.steps = steps;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<? extends O> relation) {
            DataStore<DBIDs> store = this.extendNeighborhood(database, relation);
            ExtendedNeighborhood neighborhood = new ExtendedNeighborhood(store);
            return neighborhood;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        private DataStore<DBIDs> extendNeighborhood(Database database, Relation<? extends O> relation) {
            NeighborSetPredicate innerinst = this.inner.instantiate(database, relation);
            WritableDataStore<DBIDs> store = DataStoreUtil.makeStorage(relation.getDBIDs(), 7, DBIDs.class);
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Expanding neighborhoods", relation.size(), LOG) : null;
            DBIDIter iter = relation.iterDBIDs();
            while (iter.valid()) {
                HashSetModifiableDBIDs res = DBIDUtil.newHashSet();
                res.add(iter);
                SetDBIDs todo = DBIDUtil.deref(iter);
                for (int i = 0; i < this.steps; ++i) {
                    HashSetModifiableDBIDs ntodo = DBIDUtil.newHashSet();
                    DBIDIter iter2 = todo.iter();
                    while (iter2.valid()) {
                        DBIDs add = innerinst.getNeighborDBIDs(iter2);
                        if (add != null) {
                            DBIDIter iter3 = add.iter();
                            while (iter3.valid()) {
                                if (!res.contains(iter3)) {
                                    ntodo.add(iter3);
                                    res.add(iter3);
                                }
                                iter3.advance();
                            }
                        }
                        iter2.advance();
                    }
                    if (ntodo.size() == 0) continue;
                    todo = ntodo;
                }
                store.put(iter, res);
                LOG.incrementProcessed(progress);
                iter.advance();
            }
            LOG.ensureCompleted(progress);
            return store;
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            protected static <O> NeighborSetPredicate.Factory<O> getParameterInnerNeighborhood(Parameterization config) {
                ObjectParameter param = new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class);
                if (config.grab(param)) {
                    return (NeighborSetPredicate.Factory)param.instantiateClass(config);
                }
                return null;
            }

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                this.inner = Parameterizer.getParameterInnerNeighborhood(config);
                this.steps = Parameterizer.getParameterSteps(config);
            }

            public static int getParameterSteps(Parameterization config) {
                IntParameter param = (IntParameter)new IntParameter(STEPS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(param)) {
                    return (Integer)param.getValue();
                }
                return 1;
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

