/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.AbstractPrecomputedNeighborhood;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class PrecomputedKNearestNeighborNeighborhood
extends AbstractPrecomputedNeighborhood {
    private static final Logging LOG = Logging.getLogger(PrecomputedKNearestNeighborNeighborhood.class);

    public PrecomputedKNearestNeighborNeighborhood(DataStore<DBIDs> store) {
        super(store);
    }

    @Override
    public String getLongName() {
        return "K Nearest Neighbors Neighborhood";
    }

    @Override
    public String getShortName() {
        return "knn-neighborhood";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    implements NeighborSetPredicate.Factory<O> {
        private int k;
        private DistanceFunction<? super O> distFunc;

        public Factory(int k, DistanceFunction<? super O> distFunc) {
            this.k = k;
            this.distFunc = distFunc;
        }

        @Override
        public NeighborSetPredicate instantiate(Database database, Relation<? extends O> relation) {
            KNNQuery<O> knnQuery = QueryUtil.getKNNQuery(relation, this.distFunc, new Object[0]);
            WritableDataStore<DBIDs> s = DataStoreUtil.makeStorage(relation.getDBIDs(), 6, DBIDs.class);
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                KNNList neighbors = knnQuery.getKNNForDBID(iditer, this.k);
                ArrayModifiableDBIDs neighbours = DBIDUtil.newArray(neighbors.size());
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    neighbours.add(neighbor);
                    neighbor.advance();
                }
                s.put(iditer, neighbours);
                iditer.advance();
            }
            return new PrecomputedKNearestNeighborNeighborhood(s);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distFunc.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID K_ID = new OptionID("neighborhood.k", "the number of neighbors");
            public static final OptionID DISTANCEFUNCTION_ID = new OptionID("neighborhood.distancefunction", "the distance function to use");
            int k;
            DistanceFunction<? super O> distFunc;

            @Override
            protected void makeOptions(Parameterization config) {
                ObjectParameter distP;
                super.makeOptions(config);
                IntParameter kP = new IntParameter(K_ID);
                if (config.grab(kP)) {
                    this.k = (Integer)kP.getValue();
                }
                if (config.grab(distP = new ObjectParameter(DISTANCEFUNCTION_ID, DistanceFunction.class))) {
                    this.distFunc = (DistanceFunction)distP.instantiateClass(config);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.k, this.distFunc);
            }
        }
    }
}

