/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class LinearWeightedExtendedNeighborhood
implements WeightedNeighborSetPredicate {
    private NeighborSetPredicate inner;
    private int steps;

    public LinearWeightedExtendedNeighborhood(NeighborSetPredicate inner, int steps) {
        this.inner = inner;
        this.steps = steps;
    }

    private double computeWeight(int tsteps) {
        return 1.0 - (double)((float)tsteps / (float)(this.steps + 1));
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef reference) {
        HashSetModifiableDBIDs seen = DBIDUtil.newHashSet();
        ArrayList<DoubleDBIDPair> result = new ArrayList<DoubleDBIDPair>();
        result.add(DBIDUtil.newPair(this.computeWeight(0), reference));
        seen.add(reference);
        SetDBIDs cur = DBIDUtil.deref(reference);
        for (int i = 1; i <= this.steps; ++i) {
            double weight = this.computeWeight(i);
            HashSetModifiableDBIDs add = DBIDUtil.newHashSet();
            DBIDIter iter = cur.iter();
            while (iter.valid()) {
                DBIDIter iter2 = this.inner.getNeighborDBIDs(iter).iter();
                while (iter2.valid()) {
                    if (!seen.contains(iter2)) {
                        add.add(iter2);
                        result.add(DBIDUtil.newPair(weight, (DBIDRef)iter2));
                    }
                    iter2.advance();
                }
                iter.advance();
            }
            if (add.size() == 0) break;
            cur = add;
        }
        return result;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        private NeighborSetPredicate.Factory<O> inner;
        private int steps;

        public Factory(NeighborSetPredicate.Factory<O> inner, int steps) {
            this.inner = inner;
            this.steps = steps;
        }

        @Override
        public LinearWeightedExtendedNeighborhood instantiate(Database database, Relation<? extends O> relation) {
            return new LinearWeightedExtendedNeighborhood(this.inner.instantiate(database, relation), this.steps);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID NEIGHBORHOOD_ID = new OptionID("extendedneighbors.neighborhood", "The inner neighborhood predicate to use.");
            public static final OptionID STEPS_ID = new OptionID("extendedneighbors.steps", "The number of steps allowed in the neighborhood graph.");
            private int steps;
            private NeighborSetPredicate.Factory<O> inner;

            protected static <O> NeighborSetPredicate.Factory<O> getParameterInnerNeighborhood(Parameterization config) {
                ObjectParameter param = new ObjectParameter(NEIGHBORHOOD_ID, NeighborSetPredicate.Factory.class);
                if (config.grab(param)) {
                    return (NeighborSetPredicate.Factory)param.instantiateClass(config);
                }
                return null;
            }

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                this.inner = Parameterizer.getParameterInnerNeighborhood(config);
                this.steps = Parameterizer.getParameterSteps(config);
            }

            public static int getParameterSteps(Parameterization config) {
                IntParameter param = (IntParameter)new IntParameter(STEPS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(param)) {
                    return (Integer)param.getValue();
                }
                return 1;
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.steps);
            }
        }
    }
}

