/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.weighted.WeightedNeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

public class UnweightedNeighborhoodAdapter
implements WeightedNeighborSetPredicate {
    NeighborSetPredicate inner;

    public UnweightedNeighborhoodAdapter(NeighborSetPredicate inner) {
        this.inner = inner;
    }

    @Override
    public Collection<DoubleDBIDPair> getWeightedNeighbors(DBIDRef reference) {
        DBIDs neighbors = this.inner.getNeighborDBIDs(reference);
        ArrayList<DoubleDBIDPair> adapted = new ArrayList<DoubleDBIDPair>(neighbors.size());
        DBIDIter iter = neighbors.iter();
        while (iter.valid()) {
            adapted.add(DBIDUtil.newPair(1.0, (DBIDRef)iter));
            iter.advance();
        }
        return adapted;
    }

    public static class Factory<O>
    implements WeightedNeighborSetPredicate.Factory<O> {
        NeighborSetPredicate.Factory<O> inner;

        public Factory(NeighborSetPredicate.Factory<O> inner) {
            this.inner = inner;
        }

        @Override
        public UnweightedNeighborhoodAdapter instantiate(Database database, Relation<? extends O> relation) {
            return new UnweightedNeighborhoodAdapter(this.inner.instantiate(database, relation));
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.inner.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID INNER_ID = new OptionID("neighborhood.inner", "Parameter for the non-weighted neighborhood to use.");
            NeighborSetPredicate.Factory<O> inner;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                ObjectParameter innerP = new ObjectParameter(INNER_ID, NeighborSetPredicate.Factory.class);
                if (config.grab(innerP)) {
                    this.inner = (NeighborSetPredicate.Factory)innerP.instantiateClass(config);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner);
            }
        }
    }
}

