/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import net.jafama.FastMath;

@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001)", url="https://doi.org/10.1145/375663.375668", bibkey="DBLP:conf/sigmod/AggarwalY01")
public abstract class AbstractAggarwalYuOutlier<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    public static final short DONT_CARE = -1;
    public static final short GENE_OFFSET = 0;
    protected int phi;
    protected int k;

    public AbstractAggarwalYuOutlier(int k, int phi) {
        this.k = k;
        this.phi = phi;
    }

    protected ArrayList<ArrayList<DBIDs>> buildRanges(Relation<V> relation) {
        int dim = RelationUtil.dimensionality(relation);
        int size = relation.size();
        ArrayList<ArrayList<DBIDs>> ranges = new ArrayList<ArrayList<DBIDs>>();
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(relation.getDBIDs());
        VectorUtil.SortDBIDsBySingleDimension sorter = new VectorUtil.SortDBIDsBySingleDimension(relation);
        double part = (double)size * 1.0 / (double)this.phi;
        for (int d = 0; d < dim; ++d) {
            sorter.setDimension(d);
            ids.sort(sorter);
            ArrayList<ArrayModifiableDBIDs> dimranges = new ArrayList<ArrayModifiableDBIDs>(this.phi + 1);
            int start = 0;
            DBIDArrayMIter iter = ids.iter();
            for (int r = 1; r <= this.phi; ++r) {
                int end = r < this.phi ? (int)(part * (double)r) : size;
                ArrayModifiableDBIDs currange = DBIDUtil.newArray(end - start);
                iter.seek(start);
                while (iter.getOffset() < end) {
                    currange.add(iter);
                    iter.advance();
                }
                start = end;
                dimranges.add(currange);
            }
            ranges.add(dimranges);
        }
        return ranges;
    }

    protected static double sparsity(int setsize, int dbsize, int k, double phi) {
        double fK = MathUtil.powi(1.0 / phi, k);
        return ((double)setsize - (double)dbsize * fK) / FastMath.sqrt((double)dbsize * fK * (1.0 - fK));
    }

    protected DBIDs computeSubspace(int[] subspace, ArrayList<ArrayList<DBIDs>> ranges) {
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(ranges.get(subspace[0]).get(subspace[1]));
        int e = subspace.length - 1;
        for (int i = 2; i < e; i += 2) {
            DBIDs current = ranges.get(subspace[i]).get(subspace[i + 1] - 0);
            ids.retainAll(current);
            if (ids.isEmpty()) break;
        }
        return ids;
    }

    protected DBIDs computeSubspaceForGene(short[] gene, ArrayList<ArrayList<DBIDs>> ranges) {
        HashSetModifiableDBIDs m = null;
        for (int i = 0; i < gene.length; ++i) {
            if (gene[i] == -1) continue;
            DBIDs current = ranges.get(i).get(gene[i] - 0);
            if (m == null) {
                m = DBIDUtil.newHashSet(current);
                continue;
            }
            m.retainAll(current);
        }
        assert (m != null) : "All genes set to '*', should not happen!";
        return m;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PHI_ID = new OptionID("ay.phi", "The number of equi-depth grid ranges to use in each dimension.");
        public static final OptionID K_ID = new OptionID("ay.k", "Subspace dimensionality to search for.");
        protected int phi;
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter phiP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
            if (config.grab(phiP = (IntParameter)new IntParameter(PHI_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.phi = (Integer)phiP.getValue();
            }
        }
    }
}

