/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.outlier.subspace.AbstractAggarwalYuOutlier;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

@Title(value="EAFOD: the evolutionary outlier detection algorithm")
@Description(value="Outlier detection for high dimensional data")
@Reference(authors="C. C. Aggarwal, P. S. Yu", title="Outlier detection for high dimensional data", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2001)", url="https://doi.org/10.1145/375663.375668", bibkey="DBLP:conf/sigmod/AggarwalY01")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.AggarwalYuEvolutionary"})
public class AggarwalYuEvolutionary<V extends NumberVector>
extends AbstractAggarwalYuOutlier<V> {
    private static final Logging LOG = Logging.getLogger(AggarwalYuEvolutionary.class);
    protected static final int MAX_ITERATIONS = 1000;
    protected static final double CONVERGENCE = 0.85;
    private int m;
    private RandomFactory rnd;

    public AggarwalYuEvolutionary(int k, int phi, int m, RandomFactory rnd) {
        super(k, phi);
        this.m = m;
        this.rnd = rnd;
    }

    public OutlierResult run(Database database, Relation<V> relation) {
        int dbsize = relation.size();
        ArrayList<ArrayList<DBIDs>> ranges = this.buildRanges(relation);
        Heap.UnorderedIter individuums = new EvolutionarySearch(relation, ranges, this.m, this.rnd.getSingleThreadedRandom()).run();
        WritableDoubleDataStore outlierScore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 6);
        while (individuums.valid()) {
            DBIDs ids = this.computeSubspaceForGene(((Individuum)individuums.get()).getGene(), ranges);
            double sparsityC = AggarwalYuEvolutionary.sparsity(ids.size(), dbsize, this.k, this.phi);
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double prev = outlierScore.doubleValue(iter);
                if (Double.isNaN(prev) || sparsityC < prev) {
                    outlierScore.putDouble(iter, sparsityC);
                }
                iter.advance();
            }
            individuums.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double val = outlierScore.doubleValue(iditer);
            if (Double.isNaN(val)) {
                val = 0.0;
                outlierScore.putDouble(iditer, 0.0);
            }
            minmax.put(val);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("AggarwalYuEvolutionary", "aggarwal-yu-outlier", outlierScore, relation.getDBIDs());
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, 0.0);
        return new OutlierResult(meta, scoreResult);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractAggarwalYuOutlier.Parameterizer {
        public static final OptionID M_ID = new OptionID("ay.m", "Population size for evolutionary algorithm.");
        public static final OptionID SEED_ID = new OptionID("ay.seed", "The random number generator seed.");
        protected int m = 0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            super.makeOptions(config);
            IntParameter mP = (IntParameter)new IntParameter(M_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(mP)) {
                this.m = (Integer)mP.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected AggarwalYuEvolutionary<V> makeInstance() {
            return new AggarwalYuEvolutionary(this.k, this.phi, this.m, this.rnd);
        }
    }

    private static class Individuum
    implements Comparable<Individuum> {
        double fitness;
        short[] gene;

        public Individuum(double fitness, short[] gene) {
            this.fitness = fitness;
            this.gene = gene;
        }

        public short[] getGene() {
            return this.gene;
        }

        public double getFitness() {
            return this.fitness;
        }

        public static Individuum nullIndividuum(int dim) {
            short[] gene = new short[dim];
            Arrays.fill(gene, (short)-1);
            return new Individuum(0.0, gene);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(200).append("I(f=").append(this.fitness).append(",g=");
            for (int i = 0; i < this.gene.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.gene[i] == -1) {
                    buf.append('*');
                    continue;
                }
                buf.append(this.gene[i]);
            }
            buf.append(')');
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Individuum)) {
                return false;
            }
            Individuum other = (Individuum)obj;
            if (other.gene.length != this.gene.length) {
                return false;
            }
            for (int i = 0; i < this.gene.length; ++i) {
                if (other.gene[i] == this.gene[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public int compareTo(Individuum o) {
            return Double.compare(this.fitness, o.fitness);
        }
    }

    private class EvolutionarySearch {
        final int dbsize;
        final int dim;
        final ArrayList<ArrayList<DBIDs>> ranges;
        final int m;
        private final Random random;

        public EvolutionarySearch(Relation<V> relation, ArrayList<ArrayList<DBIDs>> ranges, int m, Random random) {
            this.ranges = ranges;
            this.m = m;
            this.dbsize = relation.size();
            this.dim = RelationUtil.dimensionality(relation);
            this.random = random;
        }

        public Heap.UnorderedIter run() {
            ArrayList<Individuum> pop = this.initialPopulation(this.m);
            TopBoundedHeap bestSol = new TopBoundedHeap(this.m, Collections.reverseOrder());
            for (Individuum ind : pop) {
                bestSol.add(ind);
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("Evolutionary search iterations", LOG) : null;
            int iterations = 0;
            while (!this.checkConvergence(pop)) {
                Collections.sort(pop);
                pop = this.rouletteRankSelection(pop);
                pop = this.crossoverOptimized(pop);
                pop = this.mutation(pop, 0.25, 0.25);
                block2: for (Individuum ind : pop) {
                    Heap.UnorderedIter it = bestSol.unorderedIter();
                    while (it.valid()) {
                        if (((Individuum)it.get()).equals(ind)) continue block2;
                        it.advance();
                    }
                    bestSol.add(ind);
                }
                if (LOG.isDebuggingFinest()) {
                    StringBuilder buf = new StringBuilder(1000).append("Top solutions:\n");
                    Heap.UnorderedIter it = bestSol.unorderedIter();
                    while (it.valid()) {
                        buf.append(((Individuum)it.get()).toString()).append('\n');
                        it.advance();
                    }
                    buf.append("Population:\n");
                    for (Individuum ind : pop) {
                        buf.append(ind.toString()).append('\n');
                    }
                    LOG.debugFinest(buf.toString());
                }
                LOG.incrementProcessed(prog);
                if (++iterations <= 1000) continue;
                LOG.warning("Maximum iterations reached.");
                break;
            }
            if (prog != null) {
                prog.setCompleted(LOG);
            }
            return bestSol.unorderedIter();
        }

        private boolean checkConvergence(Collection<Individuum> pop) {
            if (pop.isEmpty()) {
                return true;
            }
            int[][] occur = new int[this.dim][AggarwalYuEvolutionary.this.phi + 1];
            for (Individuum ind : pop) {
                short[] gene = ind.getGene();
                for (int d = 0; d < this.dim; ++d) {
                    if (gene[d] == -1) {
                        int[] nArray = occur[d];
                        nArray[0] = nArray[0] + 1;
                        continue;
                    }
                    int val = gene[d] - 0;
                    if (val < 0 || val >= AggarwalYuEvolutionary.this.phi) {
                        LOG.warning("Invalid gene value encountered: " + val + " in " + ind.toString());
                        continue;
                    }
                    int[] nArray = occur[d];
                    int n = val + 1;
                    nArray[n] = nArray[n] + 1;
                }
            }
            int conv = (int)Math.floor((double)pop.size() * 0.85);
            if (LOG.isDebuggingFine()) {
                LOG.debugFine("Convergence at " + conv + " of " + pop.size() + " individuums.");
            }
            for (int d = 0; d < this.dim; ++d) {
                boolean converged = false;
                for (int val = 0; val <= AggarwalYuEvolutionary.this.phi; ++val) {
                    if (occur[d][val] < conv) continue;
                    converged = true;
                    break;
                }
                if (converged) continue;
                return false;
            }
            return true;
        }

        private ArrayList<Individuum> initialPopulation(int popsize) {
            ArrayList<Individuum> population = new ArrayList<Individuum>(popsize);
            for (int i = 0; i < popsize; ++i) {
                short[] gene = new short[this.dim];
                Arrays.fill(gene, (short)-1);
                int countDim = AggarwalYuEvolutionary.this.k;
                while (countDim > 0) {
                    int z = this.random.nextInt(this.dim);
                    if (gene[z] != -1) continue;
                    gene[z] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                    --countDim;
                }
                population.add(this.makeIndividuum(gene));
            }
            return population;
        }

        private ArrayList<Individuum> rouletteRankSelection(ArrayList<Individuum> population) {
            int popsize = population.size();
            int totalweight = popsize * (popsize + 1) >> 1;
            ArrayList<Individuum> survivors = new ArrayList<Individuum>(popsize);
            block0: for (int i = 0; i < popsize; ++i) {
                int z = this.random.nextInt(totalweight);
                int j = 0;
                int rank = popsize;
                while (j < popsize) {
                    if (z < rank) {
                        survivors.add(population.get(j));
                        continue block0;
                    }
                    z -= rank;
                    ++j;
                    --rank;
                }
            }
            assert (survivors.size() == popsize) : "Selection step failed - implementation error?";
            return survivors;
        }

        private ArrayList<Individuum> mutation(ArrayList<Individuum> population, double perc1, double perc2) {
            ArrayList<Individuum> mutations = new ArrayList<Individuum>();
            int[] QR = new int[this.dim];
            for (int j = 0; j < population.size(); ++j) {
                short[] gene = (short[])population.get(j).getGene().clone();
                int q = 0;
                int r = this.dim;
                int i = 0;
                while (i < this.dim) {
                    QR[gene[i] == -1 ? q++ : --r] = i++;
                }
                if (q > 0 && r < this.dim && this.random.nextDouble() <= perc1) {
                    int rq = this.random.nextInt(q);
                    int rr = this.random.nextInt(this.dim - r) + r;
                    int pq = QR[rq];
                    int pr = QR[rr];
                    gene[pq] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                    gene[pr] = -1;
                    QR[rq] = pr;
                    QR[rr] = pq;
                }
                if (this.random.nextDouble() <= perc2) {
                    int pr = this.random.nextInt(this.dim - r) + r;
                    gene[QR[pr]] = (short)(this.random.nextInt(AggarwalYuEvolutionary.this.phi) + 0);
                }
                mutations.add(this.makeIndividuum(gene));
            }
            return mutations;
        }

        private Individuum makeIndividuum(short[] gene) {
            DBIDs ids = AggarwalYuEvolutionary.this.computeSubspaceForGene(gene, this.ranges);
            double fitness = ids.size() > 0 ? AbstractAggarwalYuOutlier.sparsity(ids.size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi) : Double.MAX_VALUE;
            return new Individuum(fitness, gene);
        }

        private ArrayList<Individuum> crossoverOptimized(ArrayList<Individuum> population) {
            ArrayList<Individuum> crossover = new ArrayList<Individuum>();
            for (int i = 0; i < population.size() - 1; i += 2) {
                Pair<Individuum, Individuum> recombine = this.recombineOptimized(population.get(i), population.get(i + 1));
                crossover.add(recombine.getFirst());
                crossover.add(recombine.getSecond());
            }
            if (population.size() % 2 == 1) {
                crossover.add(population.get(population.size() - 1));
            }
            return crossover;
        }

        private Pair<Individuum, Individuum> recombineOptimized(Individuum parent1, Individuum parent2) {
            IntArrayList Q = new IntArrayList(this.dim);
            IntArrayList R = new IntArrayList(this.dim);
            for (int i = 0; i < this.dim; ++i) {
                if (parent1.getGene()[i] == -1 && parent2.getGene()[i] != -1) {
                    Q.add(i);
                }
                if (parent1.getGene()[i] != -1 && parent2.getGene()[i] == -1) {
                    Q.add(i);
                }
                if (parent1.getGene()[i] == -1 || parent2.getGene()[i] == -1) continue;
                R.add(i);
            }
            Individuum best = this.combineRecursive(R, 0, Individuum.nullIndividuum(this.dim).getGene(), parent1, parent2);
            short[] b = best.getGene();
            int count = AggarwalYuEvolutionary.this.k - R.size();
            IntListIterator q = Q.iterator();
            while (count > 0) {
                short[] l1 = (short[])b.clone();
                short[] l2 = (short[])b.clone();
                while (q.hasNext()) {
                    double sparsityL2;
                    int next = q.nextInt();
                    boolean s1Null = parent1.getGene()[next] == -1;
                    boolean s2Null = parent1.getGene()[next] == -1;
                    l1[next] = parent1.getGene()[next];
                    l2[next] = parent2.getGene()[next];
                    double sparsityL1 = AbstractAggarwalYuOutlier.sparsity(AggarwalYuEvolutionary.this.computeSubspaceForGene(l1, this.ranges).size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi);
                    if (sparsityL1 <= (sparsityL2 = AbstractAggarwalYuOutlier.sparsity(AggarwalYuEvolutionary.this.computeSubspaceForGene(l2, this.ranges).size(), this.dbsize, AggarwalYuEvolutionary.this.k, AggarwalYuEvolutionary.this.phi))) {
                        b = (short[])l1.clone();
                        if (!s1Null) continue;
                        --count;
                        continue;
                    }
                    b = (short[])l2.clone();
                    if (!s2Null) continue;
                    --count;
                }
            }
            short[] comp = new short[this.dim];
            for (int i = 0; i < this.dim; ++i) {
                comp[i] = b[i] == parent1.getGene()[i] ? parent2.getGene()[i] : parent2.getGene()[i];
            }
            Individuum i1 = this.makeIndividuum(b);
            Individuum i2 = this.makeIndividuum(comp);
            Pair<Individuum, Individuum> recombinePair = new Pair<Individuum, Individuum>(i1, i2);
            return recombinePair;
        }

        private Individuum combineRecursive(IntArrayList r, int i, short[] current, Individuum parent1, Individuum parent2) {
            if (i == r.size()) {
                return this.makeIndividuum(current);
            }
            int pos = r.getInt(i);
            short[] gene1 = (short[])current.clone();
            short[] gene2 = current;
            gene1[pos] = parent1.getGene()[pos];
            gene2[pos] = parent2.getGene()[pos];
            Individuum i1 = this.combineRecursive(r, i + 1, gene1, parent1, parent2);
            Individuum i2 = this.combineRecursive(r, i + 1, gene2, parent1, parent2);
            return i1.getFitness() < i2.getFitness() ? i1 : i2;
        }
    }
}

