/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="E. M\u00fcller, M. Schiffer, T. Seidl", title="Adaptive outlierness for subspace outlier ranking", booktitle="Proc. 19th ACM Int. Conf. on Information and Knowledge Management", url="https://doi.org/10.1145/1871437.1871690", bibkey="DBLP:conf/cikm/MullerSS10")
public class OUTRES
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OUTRES.class);
    private final double eps;
    private static final double K_S_CRITICAL001 = 1.63;

    public OUTRES(double eps) {
        this.eps = eps;
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore ranks = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax minmax = new DoubleMinMax();
        KernelDensityEstimator kernel = new KernelDensityEstimator(relation, this.eps);
        long[] subspace = BitsUtil.zero(kernel.dim);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("OUTRES scores", ids.size(), LOG) : null;
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            BitsUtil.zeroI(subspace);
            double score = this.outresScore(0, subspace, iditer, kernel, ids);
            ranks.putDouble(iditer, score);
            minmax.put(score);
            LOG.incrementProcessed(progress);
            iditer.advance();
        }
        LOG.ensureCompleted(progress);
        InvertedOutlierScoreMeta meta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, 1.0, 1.0);
        return new OutlierResult(meta, new MaterializedDoubleRelation("OUTRES", "outres-score", ranks, ids));
    }

    public double outresScore(int s, long[] subspace, DBIDRef id, KernelDensityEstimator kernel, DBIDs cands) {
        double score = 1.0;
        SubspaceEuclideanDistanceFunction df = new SubspaceEuclideanDistanceFunction(subspace);
        MeanVariance meanv = new MeanVariance();
        ModifiableDoubleDBIDList neighcand = DBIDUtil.newDistanceDBIDList(cands.size());
        ModifiableDoubleDBIDList nn = DBIDUtil.newDistanceDBIDList(cands.size());
        for (int i = s; i < kernel.dim; ++i) {
            assert (!BitsUtil.get(subspace, i));
            BitsUtil.setI(subspace, i);
            df.setSelectedDimensions(subspace);
            double adjustedEps = kernel.adjustedEps(kernel.dim);
            DoubleDBIDList neigh = this.initialRange(id, cands, df, adjustedEps * 2.0, kernel, neighcand);
            if (neigh.size() > 2 && this.relevantSubspace(subspace, neigh, kernel)) {
                double density = kernel.subspaceDensity(subspace, neigh);
                meanv.reset();
                DoubleDBIDListIter neighbor = neigh.iter();
                while (neighbor.valid()) {
                    this.subsetNeighborhoodQuery(neighcand, neighbor, df, adjustedEps, kernel, nn);
                    meanv.put(kernel.subspaceDensity(subspace, nn));
                    neighbor.advance();
                }
                double deviation = (meanv.getMean() - density) / (2.0 * meanv.getSampleStddev());
                if (deviation >= 1.0) {
                    score *= density / deviation;
                }
                score *= this.outresScore(i + 1, subspace, id, kernel, neighcand);
            }
            BitsUtil.clearI(subspace, i);
        }
        return score;
    }

    private DoubleDBIDList initialRange(DBIDRef obj, DBIDs cands, PrimitiveDistanceFunction<? super NumberVector> df, double eps, KernelDensityEstimator kernel, ModifiableDoubleDBIDList n) {
        n.clear();
        NumberVector o = kernel.relation.get(obj);
        double twoeps = eps * 2.0;
        int matches = 0;
        DBIDIter cand = cands.iter();
        while (cand.valid()) {
            double dist = df.distance(o, kernel.relation.get(cand));
            if (dist <= twoeps) {
                n.add(dist, cand);
                if (dist <= eps) {
                    ++matches;
                }
            }
            cand.advance();
        }
        n.sort();
        return n.slice(0, matches);
    }

    private DoubleDBIDList subsetNeighborhoodQuery(DoubleDBIDList neighc, DBIDRef dbid, PrimitiveDistanceFunction<? super NumberVector> df, double adjustedEps, KernelDensityEstimator kernel, ModifiableDoubleDBIDList n) {
        n.clear();
        NumberVector query = kernel.relation.get(dbid);
        DoubleDBIDListIter neighbor = neighc.iter();
        while (neighbor.valid()) {
            double dist = df.distance(query, kernel.relation.get(neighbor));
            if (dist <= adjustedEps) {
                n.add(dist, neighbor);
            }
            neighbor.advance();
        }
        return n;
    }

    protected boolean relevantSubspace(long[] subspace, DoubleDBIDList neigh, KernelDensityEstimator kernel) {
        double crit = 1.63 / FastMath.sqrt(neigh.size() - 2);
        double[] data = new double[neigh.size()];
        Relation<? extends NumberVector> relation = kernel.relation;
        int dim = BitsUtil.nextSetBit(subspace, 0);
        while (dim >= 0) {
            int count = 0;
            DoubleDBIDListIter neighbor = neigh.iter();
            while (neighbor.valid()) {
                data[count++] = relation.get(neighbor).doubleValue(dim);
                neighbor.advance();
            }
            assert (count == neigh.size());
            Arrays.sort(data);
            double min = data[0];
            double norm = data[data.length - 1] - min;
            boolean flag = false;
            int end = data.length - 1;
            for (int j = 1; j < end; ++j) {
                if (!(Math.abs((double)j / ((double)data.length - 2.0) - (data[j] - min) / norm) > crit)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            dim = BitsUtil.nextSetBit(subspace, dim + 1);
        }
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID D_ID = new OptionID("outres.epsilon", "Range value for OUTRES in 2 dimensions.");
        protected double eps;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter param = new DoubleParameter(D_ID);
            if (config.grab(param)) {
                this.eps = (Double)param.getValue();
            }
        }

        @Override
        protected OUTRES makeInstance() {
            return new OUTRES(this.eps);
        }
    }

    protected static class KernelDensityEstimator {
        final KernelDensityFunction kernel = EpanechnikovKernelDensityFunction.KERNEL;
        final Relation<? extends NumberVector> relation;
        final double[] epsilons;
        final double hopttwo;
        final int dim;

        public KernelDensityEstimator(Relation<? extends NumberVector> relation, double eps) {
            this.relation = relation;
            this.dim = RelationUtil.dimensionality(relation);
            this.hopttwo = this.optimalBandwidth(2);
            this.epsilons = new double[this.dim + 1];
            Arrays.fill(this.epsilons, Double.NEGATIVE_INFINITY);
            this.epsilons[2] = eps;
        }

        protected double subspaceDensity(long[] subspace, DoubleDBIDList neighbors) {
            double bandwidth = this.optimalBandwidth(BitsUtil.cardinality(subspace));
            double density = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                double v = neighbor.doubleValue() / bandwidth;
                density += v < 1.0 ? 1.0 - v * v : 0.0;
                neighbor.advance();
            }
            return density / (double)this.relation.size();
        }

        protected double optimalBandwidth(int dim) {
            double hopt = 8.0 * GammaDistribution.gamma((double)dim / 2.0 + 1.0) * (double)(dim + 4) * MathUtil.powi(2.0, dim);
            return hopt * FastMath.pow(this.relation.size(), -1.0 / (double)(dim + 4));
        }

        protected double adjustedEps(int dim) {
            double e = this.epsilons[dim];
            if (e < 0.0) {
                this.epsilons[dim] = e = this.epsilons[2] * this.optimalBandwidth(dim) / this.hopttwo;
            }
            return e;
        }
    }
}

