/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="OutRank: ranking outliers in high dimensional data")
@Description(value="Ranking outliers in high dimensional data - score 1")
@Reference(authors="Emmanuel M\u00fcller, Ira Assent, Uwe Steinhausen, Thomas Seidl", title="OutRank: ranking outliers in high dimensional data", booktitle="Proc. 24th Int. Conf. on Data Engineering (ICDE) Workshop on Ranking in Databases (DBRank)", url="https://doi.org/10.1109/ICDEW.2008.4498387", bibkey="DBLP:conf/icde/MullerASS08")
public class OutRankS1
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OutRankS1.class);
    protected SubspaceClusteringAlgorithm<? extends SubspaceModel> clusteralg;
    double alpha;

    public OutRankS1(SubspaceClusteringAlgorithm<? extends SubspaceModel> clusteralg, double alpha) {
        this.clusteralg = clusteralg;
        this.alpha = alpha;
    }

    @Override
    public OutlierResult run(Database database) {
        DBIDs ids = database.getRelation(TypeUtil.ANY, new Object[0]).getDBIDs();
        Result clustering = this.clusteralg.run(database);
        WritableDoubleDataStore score = DataStoreUtil.makeDoubleStorage(ids, 2);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            score.putDouble(iter, 0.0);
            iter.advance();
        }
        int maxdim = 0;
        int maxsize = 0;
        for (Cluster cluster : ((Clustering)clustering).getAllClusters()) {
            maxsize = Math.max(maxsize, cluster.size());
            maxdim = Math.max(maxdim, BitsUtil.cardinality(((SubspaceModel)cluster.getModel()).getDimensions()));
        }
        DoubleMinMax minmax = new DoubleMinMax();
        for (Cluster cluster : ((Clustering)clustering).getAllClusters()) {
            double relsize = (double)cluster.size() / (double)maxsize;
            double reldim = (double)BitsUtil.cardinality(((SubspaceModel)cluster.getModel()).getDimensions()) / (double)maxdim;
            DBIDIter iter2 = cluster.getIDs().iter();
            while (iter2.valid()) {
                double newscore = score.doubleValue(iter2) + this.alpha * relsize + (1.0 - this.alpha) * reldim;
                score.putDouble(iter2, newscore);
                minmax.put(newscore);
                iter2.advance();
            }
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("OutRank-S1", "OUTRANK_S1", score, ids);
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult res = new OutlierResult(invertedOutlierScoreMeta, materializedDoubleRelation);
        res.addChildResult(clustering);
        return res;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.clusteralg.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALGORITHM_ID = new OptionID("outrank.algorithm", "Subspace clustering algorithm to use.");
        public static final OptionID ALPHA_ID = new OptionID("outrank.s1.alpha", "Alpha parameter for S1 score.");
        protected SubspaceClusteringAlgorithm<? extends SubspaceModel> algorithm = null;
        protected double alpha = 0.25;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter alphaP;
            super.makeOptions(config);
            ObjectParameter algP = new ObjectParameter(ALGORITHM_ID, SubspaceClusteringAlgorithm.class);
            if (config.grab(algP)) {
                this.algorithm = (SubspaceClusteringAlgorithm)algP.instantiateClass(config);
            }
            if (config.grab(alphaP = (DoubleParameter)new DoubleParameter(ALPHA_ID, 0.25).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.alpha = alphaP.doubleValue();
            }
        }

        @Override
        protected OutRankS1 makeInstance() {
            return new OutRankS1(this.algorithm, this.alpha);
        }
    }
}

