/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.svm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_print_interface;
import libsvm.svm_problem;

@Reference(authors="B. Sch\u00f6lkopf, J. C. Platt, J. Shawe-Taylor, A. J. Smola, R. C. Williamson", title="Estimating the support of a high-dimensional distribution", booktitle="Neural computation 13.7", url="https://doi.org/10.1162/089976601750264965", bibkey="DBLP:journals/neco/ScholkopfPSSW01")
public class LibSVMOneClassOutlierDetection<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LibSVMOneClassOutlierDetection.class);
    protected SVMKernel kernel = SVMKernel.RBF;
    double nu = 0.05;
    static final svm_print_interface LOG_HELPER = new svm_print_interface(){

        @Override
        public void print(String arg0) {
            if (LOG.isVerbose()) {
                LOG.verbose(arg0);
            }
        }
    };

    public LibSVMOneClassOutlierDetection(SVMKernel kernel, double nu) {
        this.kernel = kernel;
        this.nu = nu;
    }

    public OutlierResult run(Relation<V> relation) {
        String err;
        int dim = RelationUtil.dimensionality(relation);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        svm.svm_set_print_string_function(LOG_HELPER);
        svm_parameter param = new svm_parameter();
        param.svm_type = 2;
        param.kernel_type = 0;
        param.degree = 3;
        switch (this.kernel) {
            case LINEAR: {
                param.kernel_type = 0;
                break;
            }
            case QUADRATIC: {
                param.kernel_type = 1;
                param.degree = 2;
                break;
            }
            case CUBIC: {
                param.kernel_type = 1;
                param.degree = 3;
                break;
            }
            case RBF: {
                param.kernel_type = 2;
                break;
            }
            case SIGMOID: {
                param.kernel_type = 3;
                break;
            }
            default: {
                throw new AbortException("Invalid kernel parameter: " + (Object)((Object)this.kernel));
            }
        }
        param.nu = this.nu;
        param.coef0 = 0.0;
        param.cache_size = 10000.0;
        param.C = 1.0;
        param.eps = 1.0E-4;
        param.p = 0.1;
        param.shrinking = 0;
        param.probability = 0;
        param.nr_weight = 0;
        param.weight_label = new int[0];
        param.weight = new double[0];
        param.gamma = 1.0 / (double)dim;
        svm_problem prob = new svm_problem();
        prob.l = relation.size();
        prob.x = new svm_node[prob.l][];
        prob.y = new double[prob.l];
        DBIDArrayIter iter = ids.iter();
        for (int i = 0; i < prob.l && iter.valid(); ++i) {
            NumberVector vec = (NumberVector)relation.get(iter);
            svm_node[] x = new svm_node[dim];
            for (int d = 0; d < dim; ++d) {
                x[d] = new svm_node();
                x[d].index = d + 1;
                x[d].value = vec.doubleValue(d);
            }
            prob.x[i] = x;
            prob.y[i] = 1.0;
            iter.advance();
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Training one-class SVM...");
        }
        if ((err = svm.svm_check_parameter(prob, param)) != null) {
            LOG.warning("svm_check_parameter: " + err);
        }
        svm_model model = svm.svm_train(prob, param);
        if (LOG.isVerbose()) {
            LOG.verbose("Predicting...");
        }
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax mm = new DoubleMinMax();
        DBIDArrayIter iter2 = ids.iter();
        double[] buf = new double[svm.svm_get_nr_class(model)];
        for (int i = 0; i < prob.l && iter2.valid(); ++i) {
            NumberVector vec = (NumberVector)relation.get(iter2);
            svm_node[] x = new svm_node[dim];
            for (int d = 0; d < dim; ++d) {
                x[d] = new svm_node();
                x[d].index = d + 1;
                x[d].value = vec.doubleValue(d);
            }
            svm.svm_predict_values(model, x, buf);
            double score = -buf[0];
            scores.putDouble(iter2, score);
            mm.put(score);
            iter2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("One-Class SVM Decision", "svm-outlier", scores, ids);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID KERNEL_ID = new OptionID("svm.kernel", "Kernel to use with SVM.");
        public static final OptionID NU_ID = new OptionID("svm.nu", "SVM nu parameter.");
        protected SVMKernel kernel = SVMKernel.RBF;
        protected double nu = 0.05;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter nuP;
            super.makeOptions(config);
            EnumParameter<SVMKernel> kernelP = new EnumParameter<SVMKernel>(KERNEL_ID, SVMKernel.class, SVMKernel.RBF);
            if (config.grab(kernelP)) {
                this.kernel = (SVMKernel)((Object)kernelP.getValue());
            }
            if (config.grab(nuP = new DoubleParameter(NU_ID, 0.05))) {
                this.nu = nuP.doubleValue();
            }
        }

        @Override
        protected LibSVMOneClassOutlierDetection<V> makeInstance() {
            return new LibSVMOneClassOutlierDetection(this.kernel, this.nu);
        }
    }

    public static enum SVMKernel {
        LINEAR,
        QUADRATIC,
        CUBIC,
        RBF,
        SIGMOID;

    }
}

