/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.regex.Pattern;

@Priority(value=-100)
public class ByLabelOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ByLabelOutlier.class);
    public static final String DEFAULT_PATTERN = ".*(Outlier|Noise).*";
    final Pattern pattern;

    public ByLabelOutlier(Pattern pattern) {
        this.pattern = pattern;
    }

    public ByLabelOutlier() {
        this(Pattern.compile(DEFAULT_PATTERN));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.GUESSED_LABEL);
    }

    @Override
    public OutlierResult run(Database database) {
        try {
            Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(relation);
        }
        catch (NoSupportedDataTypeException e) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public OutlierResult run(Relation<?> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            String label = relation.get(iditer).toString();
            double score = this.pattern.matcher(label).matches() ? 1.0 : 0.0;
            scores.putDouble(iditer, score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("By label outlier scores", "label-outlier", scores, relation.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore();
        return new OutlierResult(meta, scoreres);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUTLIER_PATTERN_ID = new OptionID("outlier.pattern", "Label pattern to match outliers.");
        private Pattern pattern;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            PatternParameter patternP = new PatternParameter(OUTLIER_PATTERN_ID, ByLabelOutlier.DEFAULT_PATTERN);
            if (config.grab(patternP)) {
                this.pattern = (Pattern)patternP.getValue();
            }
        }

        @Override
        protected ByLabelOutlier makeInstance() {
            return new ByLabelOutlier(this.pattern);
        }
    }
}

