/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Priority;

@Priority(value=-150)
public class TrivialAverageCoordinateOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging logger = Logging.getLogger(TrivialAverageCoordinateOutlier.class);

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH);
    }

    public OutlierResult run(Relation<? extends NumberVector> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        DoubleMinMax minmax = new DoubleMinMax();
        Mean m = new Mean();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            m.reset();
            NumberVector nv = relation.get(iditer);
            for (int i = 0; i < nv.getDimensionality(); ++i) {
                m.put(nv.doubleValue(i));
            }
            double score = m.getMean();
            scores.putDouble(iditer, score);
            minmax.put(score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Trivial mean score", "mean-outlier", scores, relation.getDBIDs());
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        return new OutlierResult(meta, scoreres);
    }

    @Override
    protected Logging getLogger() {
        return logger;
    }
}

