/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.HashSet;

public class TrivialGeneratedOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(TrivialGeneratedOutlier.class);
    double expect = 0.01;

    public TrivialGeneratedOutlier(double expect) {
        this.expect = expect;
    }

    public TrivialGeneratedOutlier() {
        this(0.01);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD, new SimpleTypeInformation<Model>(Model.class), TypeUtil.GUESSED_LABEL);
    }

    @Override
    public OutlierResult run(Database database) {
        Relation<NumberVector> vecs = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<Model> models = database.getRelation(new SimpleTypeInformation<Model>(Model.class), new Object[0]);
        try {
            Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(models, vecs, relation);
        }
        catch (NoSupportedDataTypeException e) {
            return this.run(models, vecs, database.getRelation(TypeUtil.GUESSED_LABEL, new Object[0]));
        }
    }

    public OutlierResult run(Relation<Model> models, Relation<NumberVector> vecs, Relation<?> labels) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(models.getDBIDs(), 2);
        HashSet<GeneratorSingleCluster> generators = new HashSet<GeneratorSingleCluster>();
        Object iditer = models.iterDBIDs();
        while (iditer.valid()) {
            Model model = models.get((DBIDRef)iditer);
            if (model instanceof GeneratorSingleCluster) {
                generators.add((GeneratorSingleCluster)((Object)model));
            }
            iditer.advance();
        }
        if (generators.isEmpty()) {
            LOG.warning("No generator models found for dataset - all points will be considered outliers.");
        }
        for (GeneratorSingleCluster gen : generators) {
            for (int i = 0; i < gen.getDim(); ++i) {
                Distribution dist = gen.getDistribution(i);
                if (dist instanceof NormalDistribution) continue;
                throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + dist);
            }
        }
        iditer = models.iterDBIDs();
        while (iditer.valid()) {
            double score = 1.0;
            double[] v = vecs.get((DBIDRef)iditer).toArray();
            for (GeneratorSingleCluster gen : generators) {
                double[] tv = v;
                if (gen.getTransformation() != null) {
                    tv = gen.getTransformation().applyInverse(v);
                }
                int dim = tv.length;
                double lensq = 0.0;
                int norm = 0;
                for (int i = 0; i < dim; ++i) {
                    Distribution dist = gen.getDistribution(i);
                    if (dist instanceof NormalDistribution) {
                        NormalDistribution d = (NormalDistribution)dist;
                        double delta = (tv[i] - d.getMean()) / d.getStddev();
                        lensq += delta * delta;
                        ++norm;
                        continue;
                    }
                    throw new AbortException("TrivialGeneratedOutlier currently only supports normal distributions, got: " + dist);
                }
                if ((double)norm > 0.0) {
                    score = Math.min(score, ChiSquaredDistribution.cdf(lensq, norm));
                    continue;
                }
                score = 0.0;
            }
            if (this.expect < 1.0) {
                score = this.expect * score / (1.0 - score + this.expect);
            }
            scores.putDouble((DBIDRef)iditer, score);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Model outlier scores", "model-outlier", scores, models.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(0.0, 1.0);
        return new OutlierResult(meta, scoreres);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EXPECT_ID = new OptionID("modeloutlier.expect", "Expected amount of outliers, for making the scores more intuitive. When the value is 1, the CDF will be given instead.");
        double expect;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter expectP = (DoubleParameter)((DoubleParameter)new DoubleParameter(EXPECT_ID, 0.01).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(expectP)) {
                this.expect = (Double)expectP.getValue();
            }
        }

        @Override
        protected TrivialGeneratedOutlier makeInstance() {
            return new TrivialGeneratedOutlier(this.expect);
        }
    }
}

