/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;

public abstract class AbstractProjectionAlgorithm<R extends Result>
extends AbstractAlgorithm<R> {
    private boolean keep;
    public static final OptionID KEEP_ID = new OptionID("tsne.retain-original", "Retain the original data.");

    public AbstractProjectionAlgorithm(boolean keep) {
        this.keep = keep;
    }

    protected void removePreviousRelation(Relation<?> relation) {
        if (this.keep) {
            return;
        }
        boolean first = true;
        It<Index> it = relation.getHierarchy().iterDescendants(relation).filter(Index.class);
        while (it.valid()) {
            if (first) {
                Logging.getLogger(this.getClass()).statistics("Index statistics when removing initial data relation.");
                first = false;
            }
            it.get().logStatistics();
            it.advance();
        }
        ResultUtil.removeRecursive(relation.getHierarchy(), relation);
    }
}

