/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrix;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;

public class DenseAffinityMatrix
implements AffinityMatrix {
    double[][] pij;
    ArrayDBIDs ids;

    public DenseAffinityMatrix(double[][] affinities, ArrayDBIDs ids) {
        this.pij = affinities;
        this.ids = ids;
    }

    @Override
    public double get(int i, int j) {
        return this.pij[i][j];
    }

    @Override
    public void scale(double d) {
        VMath.timesEquals(this.pij, d);
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public DBIDArrayIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int iter(int x) {
        return 0;
    }

    @Override
    public int iterAdvance(int x, int iter) {
        return iter + 1;
    }

    @Override
    public int iterDim(int x, int iter) {
        return iter;
    }

    @Override
    public double iterValue(int x, int iter) {
        return this.pij[x][iter];
    }

    @Override
    public boolean iterValid(int x, int iter) {
        return iter < this.pij.length;
    }
}

