/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrix;
import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrixBuilder;
import de.lmu.ifi.dbs.elki.algorithm.projection.DenseAffinityMatrix;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Reference(authors="G. Hinton, S. Roweis", title="Stochastic Neighbor Embedding", booktitle="Advances in Neural Information Processing Systems 15", url="http://papers.nips.cc/paper/2276-stochastic-neighbor-embedding", bibkey="DBLP:conf/nips/HintonR02")
public class GaussianAffinityMatrixBuilder<O>
implements AffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(GaussianAffinityMatrixBuilder.class);
    protected static final double MIN_PIJ = 1.0E-12;
    protected DistanceFunction<? super O> distanceFunction;
    protected double sigma;

    public GaussianAffinityMatrixBuilder(DistanceFunction<? super O> distanceFunction, double sigma) {
        this.distanceFunction = distanceFunction;
        this.sigma = sigma;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        DistanceQuery<? super O> dq = relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        double[][] dist = this.buildDistanceMatrix(ids, dq);
        return new DenseAffinityMatrix(GaussianAffinityMatrixBuilder.computePij(dist, this.sigma, initialScale), ids);
    }

    protected double[][] buildDistanceMatrix(ArrayDBIDs ids, DistanceQuery<?> dq) {
        int size = ids.size();
        double[][] dmat = new double[size][size];
        boolean square = !dq.getDistanceFunction().isSquared();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing distance matrix", size * (size - 1) >>> 1, LOG) : null;
        Duration timer = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".runtime.distancematrix").begin() : null;
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        ix.seek(0);
        while (ix.valid()) {
            double[] dmat_x = dmat[ix.getOffset()];
            iy.seek(ix.getOffset() + 1);
            while (iy.valid()) {
                double dist = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                double d = square ? dist * dist : dist;
                dmat_x[iy.getOffset()] = d;
                dmat[iy.getOffset()][ix.getOffset()] = d;
                iy.advance();
            }
            if (prog != null) {
                int row = ix.getOffset() + 1;
                prog.setProcessed(row * size - (row * (row + 1) >>> 1), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        if (timer != null) {
            LOG.statistics(timer.end());
        }
        return dmat;
    }

    protected static double[][] computePij(double[][] dist, double sigma, double initialScale) {
        int size = dist.length;
        double msigmasq = -0.5 / (sigma * sigma);
        double[][] pij = new double[size][size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing affinities", size, LOG) : null;
        Duration timer = LOG.isStatistics() ? LOG.newDuration(GaussianAffinityMatrixBuilder.class.getName() + ".runtime.pijmatrix").begin() : null;
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        for (int i = 0; i < size; ++i) {
            double logP = GaussianAffinityMatrixBuilder.computeH(i, dist[i], pij[i], msigmasq);
            if (mv != null) {
                mv.put(FastMath.exp(logP));
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics(timer.end());
            LOG.statistics(new DoubleStatistic(GaussianAffinityMatrixBuilder.class.getName() + ".perplexity.average", mv.getMean()));
            LOG.statistics(new DoubleStatistic(GaussianAffinityMatrixBuilder.class.getName() + ".perplexity.stddev", mv.getSampleStddev()));
        }
        double sum = 0.0;
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                double d = pij_i[n] + pij[j][i];
                pij_i[n] = d;
                sum += d;
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                double d = MathUtil.max(pij_i[j] * scale, 1.0E-12);
                pij[j][i] = d;
                pij_i[j] = d;
            }
        }
        return pij;
    }

    protected static double computeH(int i, double[] dist_i, double[] pij_i, double mbeta) {
        int j;
        double sumP = 0.0;
        for (j = 0; j < i; ++j) {
            pij_i[j] = FastMath.exp(dist_i[j] * mbeta);
            sumP += pij_i[j];
        }
        for (j = i + 1; j < dist_i.length; ++j) {
            pij_i[j] = FastMath.exp(dist_i[j] * mbeta);
            sumP += pij_i[j];
        }
        if (!(sumP > 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        double s = 1.0 / sumP;
        double sum = 0.0;
        for (int j2 = 0; j2 < dist_i.length; ++j2) {
            int n = j2;
            double d = pij_i[n] * s;
            pij_i[n] = d;
            sum += dist_i[j2] * d;
        }
        return FastMath.log(sumP) - mbeta * sum;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distanceFunction.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID SIGMA_ID = new OptionID("sne.sigma", "Gaussian kernel standard deviation.");
        protected double sigma;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter sigmaP;
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(sigmaP = (DoubleParameter)new DoubleParameter(SIGMA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sigma = sigmaP.doubleValue();
            }
        }

        @Override
        protected GaussianAffinityMatrixBuilder<O> makeInstance() {
            return new GaussianAffinityMatrixBuilder(this.distanceFunction, this.sigma);
        }
    }
}

