/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrix;
import de.lmu.ifi.dbs.elki.algorithm.projection.NearestNeighborAffinityMatrixBuilder;
import de.lmu.ifi.dbs.elki.algorithm.projection.SparseAffinityMatrix;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IntegerArray;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="Intrinsic t-Stochastic Neighbor Embedding")
@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP 2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
public class IntrinsicNearestNeighborAffinityMatrixBuilder<O>
extends NearestNeighborAffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(IntrinsicNearestNeighborAffinityMatrixBuilder.class);
    IntrinsicDimensionalityEstimator estimator;

    public IntrinsicNearestNeighborAffinityMatrixBuilder(DistanceFunction<? super O> distanceFunction, double perplexity, IntrinsicDimensionalityEstimator estimator) {
        super(distanceFunction, perplexity);
        this.estimator = estimator;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        int numberOfNeighbours;
        DistanceQuery<T> dq = relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        KNNQuery<T> knnq = relation.getKNNQuery(dq, (numberOfNeighbours = (int)FastMath.ceil(3.0 * this.perplexity)) + 1);
        if (knnq instanceof LinearScanQuery && numberOfNeighbours * numberOfNeighbours < relation.size()) {
            LOG.warning("To accelerate Barnes-Hut tSNE, please use an index.");
        }
        if (!(relation.getDBIDs() instanceof DBIDRange)) {
            throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        DBIDRange rids = (DBIDRange)relation.getDBIDs();
        int size = rids.size();
        double[][] pij = new double[size][];
        int[][] indices = new int[size][];
        boolean square = !SquaredEuclideanDistanceFunction.class.isInstance(dq.getDistanceFunction());
        this.computePij(rids, knnq, square, numberOfNeighbours, pij, indices, initialScale);
        SparseAffinityMatrix mat = new SparseAffinityMatrix(pij, indices, rids);
        return mat;
    }

    @Override
    protected void computePij(DBIDRange ids, KNNQuery<?> knnq, boolean square, int numberOfNeighbours, double[][] pij, int[][] indices, double initialScale) {
        Duration timer = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".runtime.neighborspijmatrix").begin() : null;
        double logPerp = FastMath.log(this.perplexity);
        DoubleArray dists = new DoubleArray(numberOfNeighbours + 10);
        IntegerArray inds = new IntegerArray(numberOfNeighbours + 10);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding neighbors and optimizing perplexity", ids.size(), LOG) : null;
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        Mean mid = LOG.isStatistics() ? new Mean() : null;
        DBIDArrayIter ix = ids.iter();
        while (ix.valid()) {
            dists.clear();
            inds.clear();
            KNNList neighbours = knnq.getKNNForDBID(ix, numberOfNeighbours + 1);
            this.convertNeighbors(ids, ix, square, neighbours, dists, inds, mid);
            double[] dArray = new double[dists.size()];
            pij[ix.getOffset()] = dArray;
            double beta = IntrinsicNearestNeighborAffinityMatrixBuilder.computeSigma(ix.getOffset(), dists, this.perplexity, logPerp, dArray);
            if (mv != null) {
                mv.put(beta > 0.0 ? FastMath.sqrt(0.5 / beta) : 0.0);
            }
            indices[ix.getOffset()] = inds.toArray();
            LOG.incrementProcessed(prog);
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        if (mid != null) {
            LOG.statistics(new DoubleStatistic(this.getClass() + ".average-original-id", mid.getMean()));
        }
        double sum = 0.0;
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int offi = 0; offi < pij_i.length; ++offi) {
                int j = indices[i][offi];
                if (j > i) continue;
                assert (i != j);
                int offj = IntrinsicNearestNeighborAffinityMatrixBuilder.containsIndex(indices[j], i);
                if (offj < 0) continue;
                sum += FastMath.sqrt(pij_i[offi] * pij[j][offj]);
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int offi = 0; offi < pij_i.length; ++offi) {
                int j = indices[i][offi];
                assert (i != j);
                int offj = IntrinsicNearestNeighborAffinityMatrixBuilder.containsIndex(indices[j], i);
                if (offj >= 0) {
                    assert (indices[j][offj] == i);
                    if (i >= j) continue;
                    double val = FastMath.sqrt(pij_i[offi] * pij[j][offj]);
                    double d = MathUtil.max(val * scale, 1.0E-12);
                    pij[j][offj] = d;
                    pij_i[offi] = d;
                    continue;
                }
                pij_i[offi] = 0.0;
            }
        }
        if (LOG.isStatistics()) {
            LOG.statistics(timer.end());
            LOG.statistics(new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.average", mv.getMean()));
            LOG.statistics(new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.stddev", mv.getSampleStddev()));
        }
    }

    protected void convertNeighbors(DBIDRange ids, DBIDRef ix, boolean square, KNNList neighbours, DoubleArray dist, IntegerArray ind, Mean m) {
        double max;
        DoubleDBIDListIter iter = neighbours.iter();
        while (iter.valid()) {
            if (!DBIDUtil.equal(iter, ix)) {
                dist.add(iter.doubleValue());
                ind.add(ids.getOffset(iter));
            }
            iter.advance();
        }
        double id = this.estimator.estimate(dist.data, dist.size);
        if (m != null) {
            m.put(id);
        }
        if ((max = dist.data[dist.size - 1]) > 0.0) {
            double scaleexp = id * 0.5;
            double scalelin = 1.0 / max;
            for (int i = 0; i < dist.size; ++i) {
                dist.data[i] = FastMath.pow(dist.data[i] * scalelin, scaleexp);
            }
        }
    }

    public static class Parameterizer<O>
    extends NearestNeighborAffinityMatrixBuilder.Parameterizer<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("itsne.estimator", "Estimator for intrinsic dimensionality.");
        IntrinsicDimensionalityEstimator estimator = AggregatedHillEstimator.STATIC;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter estimatorP = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, AggregatedHillEstimator.class);
            if (config.grab(estimatorP)) {
                this.estimator = (IntrinsicDimensionalityEstimator)estimatorP.instantiateClass(config);
            }
        }

        @Override
        protected IntrinsicNearestNeighborAffinityMatrixBuilder<O> makeInstance() {
            return new IntrinsicNearestNeighborAffinityMatrixBuilder(this.distanceFunction, this.perplexity, this.estimator);
        }
    }
}

