/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrix;
import de.lmu.ifi.dbs.elki.algorithm.projection.PerplexityAffinityMatrixBuilder;
import de.lmu.ifi.dbs.elki.algorithm.projection.SparseAffinityMatrix;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IntegerArray;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import net.jafama.FastMath;

@Reference(authors="L. J. P. van der Maaten", title="Accelerating t-SNE using Tree-Based Algorithms", booktitle="Journal of Machine Learning Research 15", url="http://dl.acm.org/citation.cfm?id=2697068", bibkey="DBLP:journals/jmlr/Maaten14")
public class NearestNeighborAffinityMatrixBuilder<O>
extends PerplexityAffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(NearestNeighborAffinityMatrixBuilder.class);
    protected int numberOfNeighbours;

    public NearestNeighborAffinityMatrixBuilder(DistanceFunction<? super O> distanceFunction, double perplexity) {
        super(distanceFunction, perplexity);
        this.numberOfNeighbours = (int)FastMath.ceil(3.0 * perplexity);
    }

    public NearestNeighborAffinityMatrixBuilder(DistanceFunction<? super O> distanceFunction, double perplexity, int neighbors) {
        super(distanceFunction, perplexity);
        this.numberOfNeighbours = neighbors;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        DistanceQuery<T> dq = relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        KNNQuery<T> knnq = relation.getKNNQuery(dq, this.numberOfNeighbours + 1);
        if (knnq instanceof LinearScanQuery && this.numberOfNeighbours * this.numberOfNeighbours < relation.size()) {
            LOG.warning("To accelerate Barnes-Hut tSNE, please use an index.");
        }
        if (!(relation.getDBIDs() instanceof DBIDRange)) {
            throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        DBIDRange rids = (DBIDRange)relation.getDBIDs();
        int size = rids.size();
        double[][] pij = new double[size][];
        int[][] indices = new int[size][];
        boolean square = !dq.getDistanceFunction().isSquared();
        this.computePij(rids, knnq, square, this.numberOfNeighbours, pij, indices, initialScale);
        SparseAffinityMatrix mat = new SparseAffinityMatrix(pij, indices, rids);
        return mat;
    }

    protected void computePij(DBIDRange ids, KNNQuery<?> knnq, boolean square, int numberOfNeighbours, double[][] pij, int[][] indices, double initialScale) {
        Duration timer = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".runtime.neighborspijmatrix").begin() : null;
        double logPerp = FastMath.log(this.perplexity);
        DoubleArray dists = new DoubleArray(numberOfNeighbours + 10);
        IntegerArray inds = new IntegerArray(numberOfNeighbours + 10);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding neighbors and optimizing perplexity", ids.size(), LOG) : null;
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        DBIDArrayIter ix = ids.iter();
        while (ix.valid()) {
            dists.clear();
            inds.clear();
            KNNList neighbours = knnq.getKNNForDBID(ix, numberOfNeighbours + 1);
            this.convertNeighbors(ids, ix, square, neighbours, dists, inds);
            double[] dArray = new double[dists.size()];
            pij[ix.getOffset()] = dArray;
            double beta = NearestNeighborAffinityMatrixBuilder.computeSigma(ix.getOffset(), dists, this.perplexity, logPerp, dArray);
            if (mv != null) {
                mv.put(beta > 0.0 ? FastMath.sqrt(0.5 / beta) : 0.0);
            }
            indices[ix.getOffset()] = inds.toArray();
            LOG.incrementProcessed(prog);
            ix.advance();
        }
        LOG.ensureCompleted(prog);
        double sum = 0.0;
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < pij_i.length; ++j) {
                sum += pij_i[j];
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 0; i < pij.length; ++i) {
            double[] pij_i = pij[i];
            for (int offi = 0; offi < pij_i.length; ++offi) {
                int j = indices[i][offi];
                assert (i != j);
                int offj = NearestNeighborAffinityMatrixBuilder.containsIndex(indices[j], i);
                if (offj >= 0) {
                    assert (indices[j][offj] == i);
                    if (i >= j) continue;
                    double val = pij_i[offi] + pij[j][offj];
                    double d = MathUtil.max(val * scale, 1.0E-12);
                    pij[j][offj] = d;
                    pij_i[offi] = d;
                    continue;
                }
                pij_i[offi] = MathUtil.max(pij_i[offi] * scale, 1.0E-12);
            }
        }
        if (LOG.isStatistics()) {
            LOG.statistics(timer.end());
            LOG.statistics(new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.average", mv.getMean()));
            LOG.statistics(new DoubleStatistic(NearestNeighborAffinityMatrixBuilder.class.getName() + ".sigma.stddev", mv.getSampleStddev()));
        }
    }

    protected void convertNeighbors(DBIDRange ids, DBIDRef ix, boolean square, KNNList neighbours, DoubleArray dist, IntegerArray ind) {
        DoubleDBIDListIter iter = neighbours.iter();
        while (iter.valid()) {
            if (!DBIDUtil.equal(iter, ix)) {
                double d = iter.doubleValue();
                dist.add(square ? d * d : d);
                ind.add(ids.getOffset(iter));
            }
            iter.advance();
        }
    }

    protected static double computeSigma(int i, DoubleArray pij_row, double perplexity, double log_perp, double[] pij_i) {
        double max = pij_row.get((int)FastMath.ceil(perplexity)) / Math.E;
        double beta = 1.0 / max;
        double diff = NearestNeighborAffinityMatrixBuilder.computeH(pij_row, pij_i, -beta) - log_perp;
        double betaMin = 0.0;
        double betaMax = Double.POSITIVE_INFINITY;
        for (int tries = 0; tries < 50 && Math.abs(diff) > 1.0E-5; ++tries) {
            if (diff > 0.0) {
                betaMin = beta;
                beta += betaMax == Double.POSITIVE_INFINITY ? beta : (betaMax - beta) * 0.5;
            } else {
                betaMax = beta;
                beta -= (beta - betaMin) * 0.5;
            }
            diff = NearestNeighborAffinityMatrixBuilder.computeH(pij_row, pij_i, -beta) - log_perp;
        }
        return beta;
    }

    protected static double computeH(DoubleArray dist_i, double[] pij_row, double mbeta) {
        int len = dist_i.size();
        assert (pij_row.length == len);
        double sumP = 0.0;
        for (int j = 0; j < len; ++j) {
            pij_row[j] = FastMath.exp(dist_i.get(j) * mbeta);
            sumP += pij_row[j];
        }
        if (!(sumP > 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        double s = 1.0 / sumP;
        double sum = 0.0;
        for (int j = 0; j < len; ++j) {
            int n = j;
            double d = pij_row[n] * s;
            pij_row[n] = d;
            sum += dist_i.get(j) * d;
        }
        return FastMath.log(sumP) - mbeta * sum;
    }

    protected static int containsIndex(int[] is, int i) {
        for (int j = 0; j < is.length; ++j) {
            if (i != is[j]) continue;
            return j;
        }
        return -1;
    }

    public static class Parameterizer<O>
    extends PerplexityAffinityMatrixBuilder.Parameterizer<O> {
        @Override
        protected NearestNeighborAffinityMatrixBuilder<O> makeInstance() {
            return new NearestNeighborAffinityMatrixBuilder(this.distanceFunction, this.perplexity);
        }
    }
}

