/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.projection;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.projection.AffinityMatrix;
import de.lmu.ifi.dbs.elki.algorithm.projection.DenseAffinityMatrix;
import de.lmu.ifi.dbs.elki.algorithm.projection.GaussianAffinityMatrixBuilder;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Reference(authors="G. Hinton, S. Roweis", title="Stochastic Neighbor Embedding", booktitle="Advances in Neural Information Processing Systems 15", url="http://papers.nips.cc/paper/2276-stochastic-neighbor-embedding", bibkey="DBLP:conf/nips/HintonR02")
public class PerplexityAffinityMatrixBuilder<O>
extends GaussianAffinityMatrixBuilder<O> {
    private static final Logging LOG = Logging.getLogger(PerplexityAffinityMatrixBuilder.class);
    protected static final double PERPLEXITY_ERROR = 1.0E-5;
    protected static final int PERPLEXITY_MAXITER = 50;
    protected static final double MIN_PIJ = 1.0E-12;
    protected DistanceFunction<? super O> distanceFunction;
    protected double perplexity;

    public PerplexityAffinityMatrixBuilder(DistanceFunction<? super O> distanceFunction, double perplexity) {
        super(distanceFunction, Double.NaN);
        this.distanceFunction = distanceFunction;
        this.perplexity = perplexity;
    }

    @Override
    public <T extends O> AffinityMatrix computeAffinityMatrix(Relation<T> relation, double initialScale) {
        DistanceQuery<? super O> dq = relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        double[][] dist = this.buildDistanceMatrix(ids, dq);
        return new DenseAffinityMatrix(PerplexityAffinityMatrixBuilder.computePij(dist, this.perplexity, initialScale), ids);
    }

    protected static double[][] computePij(double[][] dist, double perplexity, double initialScale) {
        int size = dist.length;
        double logPerp = FastMath.log(perplexity);
        double[][] pij = new double[size][size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Optimizing perplexities", size, LOG) : null;
        Duration timer = LOG.isStatistics() ? LOG.newDuration(PerplexityAffinityMatrixBuilder.class.getName() + ".runtime.pijmatrix").begin() : null;
        MeanVariance mv = LOG.isStatistics() ? new MeanVariance() : null;
        for (int i = 0; i < size; ++i) {
            double beta = PerplexityAffinityMatrixBuilder.computePi(i, dist[i], pij[i], perplexity, logPerp);
            if (mv != null) {
                mv.put(beta > 0.0 ? FastMath.sqrt(0.5 / beta) : 0.0);
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics(timer.end());
            LOG.statistics(new DoubleStatistic(PerplexityAffinityMatrixBuilder.class.getName() + ".sigma.average", mv.getMean()));
            LOG.statistics(new DoubleStatistic(PerplexityAffinityMatrixBuilder.class.getName() + ".sigma.stddev", mv.getSampleStddev()));
        }
        double sum = 0.0;
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                double d = pij_i[n] + pij[j][i];
                pij_i[n] = d;
                sum += d;
            }
        }
        double scale = initialScale / (2.0 * sum);
        for (int i = 1; i < size; ++i) {
            double[] pij_i = pij[i];
            for (int j = 0; j < i; ++j) {
                double d = MathUtil.max(pij_i[j] * scale, 1.0E-12);
                pij[j][i] = d;
                pij_i[j] = d;
            }
        }
        return pij;
    }

    protected static double computePi(int i, double[] dist_i, double[] pij_i, double perplexity, double logPerp) {
        double beta = PerplexityAffinityMatrixBuilder.estimateInitialBeta(dist_i, perplexity);
        double diff = PerplexityAffinityMatrixBuilder.computeH(i, dist_i, pij_i, -beta) - logPerp;
        double betaMin = 0.0;
        double betaMax = Double.POSITIVE_INFINITY;
        for (int tries = 0; tries < 50 && Math.abs(diff) > 1.0E-5; ++tries) {
            if (diff > 0.0) {
                betaMin = beta;
                beta += betaMax == Double.POSITIVE_INFINITY ? beta : (betaMax - beta) * 0.5;
            } else {
                betaMax = beta;
                beta -= (beta - betaMin) * 0.5;
            }
            diff = PerplexityAffinityMatrixBuilder.computeH(i, dist_i, pij_i, -beta) - logPerp;
        }
        return beta;
    }

    protected static double estimateInitialBeta(double[] dist_i, double perplexity) {
        double sum = 0.0;
        for (double d : dist_i) {
            double d2 = d * d;
            sum += d2 < Double.POSITIVE_INFINITY ? d2 : 0.0;
        }
        return sum > 0.0 && sum < Double.POSITIVE_INFINITY ? 0.5 / sum * perplexity * ((double)dist_i.length - 1.0) : 1.0;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distanceFunction.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID PERPLEXITY_ID = new OptionID("sne.perplexity", "Desired perplexity (approximately the number of neighbors to preserve)");
        protected double perplexity;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter perplexityP;
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(perplexityP = (DoubleParameter)((DoubleParameter)new DoubleParameter(PERPLEXITY_ID).setDefaultValue((Object)40.0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.perplexity = perplexityP.doubleValue();
            }
        }

        @Override
        protected PerplexityAffinityMatrixBuilder<O> makeInstance() {
            return new PerplexityAffinityMatrixBuilder(this.distanceFunction, this.perplexity);
        }
    }
}

