/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ListSizeConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Description(value="Setup a scaling so that all dimensions are scaled equally in visualization.")
public class AddSingleScale
implements Algorithm {
    double[] minmax = null;

    public AddSingleScale(double[] minmax) {
        this.minmax = minmax;
    }

    @Override
    public Result run(Database database) {
        for (Relation<?> rel : database.getRelations()) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) continue;
            ScalesResult res = this.run(rel);
            ResultUtil.addChildResult(rel, res);
        }
        return null;
    }

    private ScalesResult run(Relation<? extends NumberVector> rel) {
        int dim = RelationUtil.dimensionality(rel);
        LinearScale[] scales = new LinearScale[dim];
        if (this.minmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            DBIDIter iditer = rel.iterDBIDs();
            while (iditer.valid()) {
                NumberVector vec = rel.get(iditer);
                for (int d = 0; d < dim; ++d) {
                    double val = vec.doubleValue(d);
                    if (val != val) continue;
                    mm.put(val);
                }
                iditer.advance();
            }
            LinearScale scale = new LinearScale(mm.getMin(), mm.getMax());
            for (int i = 0; i < dim; ++i) {
                scales[i] = scale;
            }
        } else {
            LinearScale scale = new LinearScale(this.minmax[0], this.minmax[1]);
            for (int i = 0; i < dim; ++i) {
                scales[i] = scale;
            }
        }
        ScalesResult res = new ScalesResult(scales);
        return res;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINMAX_ID = new OptionID("scales.minmax", "Forcibly set the scales to the given range.");
        double[] minmax = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleListParameter minmaxP = (DoubleListParameter)((DoubleListParameter)new DoubleListParameter(MINMAX_ID).setOptional(true)).addConstraint((ParameterConstraint)new ListSizeConstraint(2));
            if (config.grab(minmaxP)) {
                this.minmax = (double[])((double[])minmaxP.getValue()).clone();
            }
        }

        @Override
        protected AddSingleScale makeInstance() {
            return new AddSingleScale(this.minmax);
        }
    }
}

