/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;

@Description(value="Setup a scaling so that all dimensions have the same value range.")
public class AddUniformScale
implements Algorithm {
    @Override
    public Result run(Database database) {
        for (Relation<?> rel : database.getRelations()) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) continue;
            ScalesResult res = this.run(rel);
            ResultUtil.addChildResult(rel, res);
        }
        return null;
    }

    private ScalesResult run(Relation<? extends NumberVector> rel) {
        double[][] mms = RelationUtil.computeMinMax(rel);
        int dim = mms[0].length;
        double delta = 0.0;
        for (int d = 0; d < dim; ++d) {
            double del = mms[1][d] - mms[0][d];
            delta = del > delta ? del : delta;
        }
        if (delta < Double.MIN_NORMAL) {
            delta = 1.0;
        }
        int log10res = (int)Math.ceil(Math.log10(delta / 30.0));
        double res = MathUtil.powi(10.0, log10res);
        double target = Math.ceil(delta / res) * res;
        LinearScale[] scales = new LinearScale[dim];
        for (int d = 0; d < dim; ++d) {
            double mid = (mms[0][d] + mms[1][d] - target) * 0.5;
            double min = Math.floor(mid / res) * res;
            double max = Math.ceil((mid + target) / res) * res;
            scales[d] = new LinearScale(min, max);
        }
        return new ScalesResult(scales);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }
}

