/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DistanceQuantileSampler<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<double[]>> {
    private static final Logging LOG = Logging.getLogger(DistanceQuantileSampler.class);
    private static final String PREFIX = DistanceQuantileSampler.class.getName();
    private double quantile;
    private double sampling;
    private boolean nozeros;
    private RandomFactory rand;

    public DistanceQuantileSampler(DistanceFunction<? super O> distanceFunction, double quantile, double sampling, boolean nozeros, RandomFactory rand) {
        super(distanceFunction);
        this.quantile = quantile;
        this.sampling = sampling;
        this.nozeros = nozeros;
        this.rand = rand;
    }

    public CollectionResult<double[]> run(Database database, Relation<O> rel) {
        long ssize;
        DistanceQuery<O> dq = rel.getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        int size = rel.size();
        long pairs = (long)size * (long)size >> 1;
        long l = ssize = this.sampling <= 1.0 ? (long)Math.ceil(this.sampling * (double)pairs) : (long)this.sampling;
        if (ssize > Integer.MAX_VALUE) {
            throw new AbortException("Sampling size too large.");
        }
        int qsize = this.quantile <= 0.0 ? 1 : (int)Math.ceil(this.quantile * (double)ssize);
        DoubleMaxHeap heap = new DoubleMaxHeap(qsize);
        ArrayDBIDs ids = DBIDUtil.ensureArray(rel.getDBIDs());
        DBIDArrayIter i1 = ids.iter();
        DBIDArrayIter i2 = ids.iter();
        Random r = this.rand.getSingleThreadedRandom();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Sampling", (int)ssize, LOG) : null;
        for (long i = 0L; i < ssize; ++i) {
            int x = r.nextInt(size - 1) + 1;
            int y = r.nextInt(x);
            double dist = dq.distance((DBIDRef)i1.seek(x), (DBIDRef)i2.seek(y));
            if (dist != dist || this.nozeros && dist < Double.MIN_NORMAL) continue;
            heap.add(dist, qsize);
            LOG.incrementProcessed(prog);
        }
        LOG.statistics(new DoubleStatistic(PREFIX + ".quantile", this.quantile));
        LOG.statistics(new LongStatistic(PREFIX + ".samplesize", ssize));
        LOG.statistics(new DoubleStatistic(PREFIX + ".distance", heap.peek()));
        LOG.ensureCompleted(prog);
        List<String> header = Arrays.asList("Distance");
        List data = Arrays.asList(new double[][]{{heap.peek()}});
        return new CollectionResult<double[]>("Distances sample", "distance-sample", data, header);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID QUANTILE_ID = new OptionID("distsample.quantile", "Quantile to compute.");
        public static final OptionID SAMPLING_ID = new OptionID("distsample.sample", "Number of distances to compute, either relative (values less than 1), or absolute.");
        public static final OptionID NOZEROS_ID = new OptionID("distsample.nozeros", "Ignore zero distances, beneficial for data sets with many duplicates.");
        public static final OptionID SEED_ID = new OptionID("distsample.seed", "Random generator seed.");
        private double quantile;
        private double sampling;
        private boolean nozeros;
        private RandomFactory rand;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randP;
            Flag nozerosF;
            DoubleParameter samplingP;
            super.makeOptions(config);
            DoubleParameter quantileP = (DoubleParameter)((DoubleParameter)new DoubleParameter(QUANTILE_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (config.grab(quantileP)) {
                this.quantile = quantileP.doubleValue();
            }
            if (config.grab(samplingP = (DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sampling = samplingP.doubleValue();
            }
            if (config.grab(nozerosF = new Flag(NOZEROS_ID))) {
                this.nozeros = nozerosF.isTrue();
            }
            if (config.grab(randP = new RandomParameter(SEED_ID))) {
                this.rand = (RandomFactory)randP.getValue();
            }
        }

        @Override
        protected DistanceQuantileSampler<O> makeInstance() {
            return new DistanceQuantileSampler(this.distanceFunction, this.quantile, this.sampling, this.nozeros, this.rand);
        }
    }
}

