/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.GEDEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class EstimateIntrinsicDimensionality<O>
extends AbstractDistanceBasedAlgorithm<O, Result> {
    private static final Logging LOG = Logging.getLogger(EstimateIntrinsicDimensionality.class);
    protected double krate;
    protected double samples;
    protected IntrinsicDimensionalityEstimator estimator;

    public EstimateIntrinsicDimensionality(DistanceFunction<? super O> distanceFunction, IntrinsicDimensionalityEstimator estimator, double krate, double samples) {
        super(distanceFunction);
        this.estimator = estimator;
        this.krate = krate;
        this.samples = samples;
    }

    public Result run(Database database, Relation<O> relation) {
        DBIDs allids = relation.getDBIDs();
        int ssize = (int)(this.samples > 1.0 ? this.samples : Math.ceil(this.samples * (double)allids.size()));
        int kk = 1 + (int)(this.krate > 1.0 ? this.krate : Math.ceil(this.krate * (double)allids.size()));
        ModifiableDBIDs sampleids = DBIDUtil.randomSample(allids, ssize, RandomFactory.DEFAULT);
        DistanceQuery<O> dq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnq = database.getKNNQuery(dq, kk);
        double[] idim = new double[ssize];
        int samples = 0;
        DBIDIter iter = sampleids.iter();
        while (iter.valid()) {
            idim[samples] = this.estimator.estimate(knnq, (DBIDRef)iter, kk);
            ++samples;
            iter.advance();
        }
        double id = samples > 1 ? QuickSelect.median(idim, 0, samples) : -1.0;
        LOG.statistics(new DoubleStatistic(EstimateIntrinsicDimensionality.class.getName() + ".intrinsic-dimensionality", id));
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("idist.estimator", "Estimation method for intrinsic dimensionality.");
        public static final OptionID KRATE_ID = new OptionID("idist.k", "Number of kNN (absolute or relative)");
        public static final OptionID SAMPLES_ID = new OptionID("idist.sampling", "Sample size (absolute or relative)");
        protected IntrinsicDimensionalityEstimator estimator;
        protected double krate;
        protected double samples;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter samplesP;
            DoubleParameter krateP;
            super.makeOptions(config);
            ObjectParameter estimatorP = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, GEDEstimator.class);
            if (config.grab(estimatorP)) {
                this.estimator = (IntrinsicDimensionalityEstimator)estimatorP.instantiateClass(config);
            }
            if (config.grab(krateP = (DoubleParameter)new DoubleParameter(KRATE_ID, 50.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.krate = krateP.doubleValue();
            }
            if (config.grab(samplesP = (DoubleParameter)new DoubleParameter(SAMPLES_ID, 0.1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.samples = samplesP.doubleValue();
            }
        }

        @Override
        protected EstimateIntrinsicDimensionality<O> makeInstance() {
            return new EstimateIntrinsicDimensionality(this.distanceFunction, this.estimator, this.krate, this.samples);
        }
    }
}

