/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EvaluateClustering;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

@Title(value="Evaluate Ranking Quality")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class EvaluateRankingQuality<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, CollectionResult<double[]>> {
    private static final Logging LOG = Logging.getLogger(EvaluateRankingQuality.class);
    int numbins = 20;

    public EvaluateRankingQuality(DistanceFunction<? super V> distanceFunction, int numbins) {
        super(distanceFunction);
        this.numbins = numbins;
    }

    @Override
    public HistogramResult run(Database database) {
        Relation relation = database.getRelation(this.getInputTypeRestriction()[0], new Object[0]);
        DistanceQuery distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery knnQuery = database.getKNNQuery(distQuery, relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose("Preprocessing clusters...");
        }
        List split = ((Clustering)new ByLabelOrAllInOneClustering().run(database)).getAllClusters();
        HashMap<Cluster, double[]> averages = new HashMap<Cluster, double[]>(split.size());
        HashMap<Cluster, double[][]> covmats = new HashMap<Cluster, double[][]>(split.size());
        for (Cluster cluster : split) {
            CovarianceMatrix covmat = CovarianceMatrix.make(relation, cluster.getIDs());
            averages.put(cluster, covmat.getMeanVector());
            covmats.put(cluster, covmat.destroyToPopulationMatrix());
        }
        ObjHistogram<MeanVariance> hist = new ObjHistogram<MeanVariance>(this.numbins, 0.0, 1.0, MeanVariance::new);
        if (LOG.isVerbose()) {
            LOG.verbose("Processing points...");
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing ROC AUC values", relation.size(), LOG) : null;
        ROCEvaluation roc = new ROCEvaluation();
        for (Cluster cluster : split) {
            ModifiableDoubleDBIDList cmem = DBIDUtil.newDistanceDBIDList(cluster.size());
            double[] av = (double[])averages.get(cluster);
            double[][] covm = (double[][])covmats.get(cluster);
            DBIDIter iter = cluster.getIDs().iter();
            while (iter.valid()) {
                double[] v = VMath.minusEquals(((NumberVector)relation.get(iter)).toArray(), av);
                cmem.add(VMath.transposeTimesTimes(v, covm, v), iter);
                iter.advance();
            }
            cmem.sort();
            DoubleDBIDListMIter it = cmem.iter();
            while (it.valid()) {
                KNNList knn = knnQuery.getKNNForDBID(it, relation.size());
                double result = EvaluateClustering.evaluateRanking(roc, cluster, knn);
                hist.get((double)it.getOffset() / (double)cluster.size()).put(result);
                LOG.incrementProcessed(finiteProgress);
                it.advance();
            }
        }
        LOG.ensureCompleted(finiteProgress);
        ArrayList<double[]> res = new ArrayList<double[]>(relation.size());
        ObjHistogram.Iter iter = hist.iter();
        while (iter.valid()) {
            res.add(new double[]{iter.getCenter(), ((MeanVariance)iter.getValue()).getCount(), ((MeanVariance)iter.getValue()).getMean(), ((MeanVariance)iter.getValue()).getSampleVariance()});
            iter.advance();
        }
        return new HistogramResult("Ranking Quality Histogram", "ranking-histogram", (Collection<double[]>)res);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected int numbins = 20;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = (IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 20).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(param)) {
                this.numbins = (Integer)param.getValue();
            }
        }

        @Override
        protected EvaluateRankingQuality<V> makeInstance() {
            return new EvaluateRankingQuality(this.distanceFunction, this.numbins);
        }
    }
}

