/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class RangeQuerySelectivity<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, Result> {
    private static final Logging LOG = Logging.getLogger(RangeQuerySelectivity.class);
    protected double radius;
    protected double sampling = 1.0;
    protected RandomFactory random = null;

    public RangeQuerySelectivity(DistanceFunction<? super V> distanceFunction, double radius, double sampling, RandomFactory random) {
        super(distanceFunction);
        this.radius = radius;
        this.sampling = sampling;
        this.random = random;
    }

    public Result run(Database database, Relation<V> relation) {
        DistanceQuery<V> distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<V> rangeQuery = database.getRangeQuery(distQuery, this.radius);
        MeanVariance numres = new MeanVariance();
        DBIDs ids = DBIDUtil.randomSample(relation.getDBIDs(), this.sampling, this.random);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Performing range queries", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            numres.put(rangeQuery.getRangeForDBID(iter, this.radius).size());
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        String prefix = this.getClass().getName();
        LOG.statistics(new DoubleStatistic(prefix + ".mean", numres.getMean()));
        LOG.statistics(new DoubleStatistic(prefix + ".std", numres.getSampleStddev()));
        LOG.statistics(new DoubleStatistic(prefix + ".norm.mean", numres.getMean() / (double)relation.size()));
        LOG.statistics(new DoubleStatistic(prefix + ".norm.std", numres.getSampleStddev() / (double)relation.size()));
        LOG.statistics(new LongStatistic(prefix + ".samplesize", ids.size()));
        return null;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID RADIUS_ID = new OptionID("selectivity.radius", "Radius to use for selectivity estimation.");
        public static final OptionID SAMPLING_ID = new OptionID("selectivity.sampling", "Relative amount of object to sample.");
        public static final OptionID SEED_ID = new OptionID("selectivity.sampling-seed", "Random seed for deterministic sampling.");
        protected double radius;
        protected double sampling = 1.0;
        protected RandomFactory random = RandomFactory.DEFAULT;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            DoubleParameter samplingP;
            super.makeOptions(config);
            DoubleParameter param = (DoubleParameter)new DoubleParameter(RADIUS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(param)) {
                this.radius = param.doubleValue();
            }
            if (config.grab(samplingP = (DoubleParameter)((DoubleParameter)((DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).setOptional(true))) {
                this.sampling = (Double)samplingP.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.random = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RangeQuerySelectivity<V> makeInstance() {
            return new RangeQuerySelectivity(this.distanceFunction, this.radius, this.sampling, this.random);
        }
    }
}

