/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EvaluateClustering;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.DoubleHistogram;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Title(value="Ranking Quality Histogram")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class RankingQualityHistogram<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<double[]>> {
    private static final Logging LOG = Logging.getLogger(RankingQualityHistogram.class);
    protected int numbins = 100;

    public RankingQualityHistogram(DistanceFunction<? super O> distanceFunction, int numbins) {
        super(distanceFunction);
        this.numbins = numbins;
    }

    public HistogramResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distanceQuery, relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose("Preprocessing clusters...");
        }
        List split = ((Clustering)new ByLabelOrAllInOneClustering().run(database)).getAllClusters();
        DoubleHistogram hist = new DoubleHistogram(this.numbins, 0.0, 1.0);
        if (LOG.isVerbose()) {
            LOG.verbose("Processing points...");
        }
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Computing ROC AUC values", relation.size(), LOG) : null;
        ROCEvaluation roc = new ROCEvaluation();
        MeanVariance mv = new MeanVariance();
        for (Cluster cluster : split) {
            DBIDIter iter = cluster.getIDs().iter();
            while (iter.valid()) {
                KNNList knn = knnQuery.getKNNForDBID(iter, relation.size());
                double result = EvaluateClustering.evaluateRanking(roc, cluster, knn);
                mv.put(result);
                hist.increment(result, 1.0 / (double)relation.size());
                LOG.incrementProcessed(progress);
                iter.advance();
            }
        }
        LOG.ensureCompleted(progress);
        ArrayList<double[]> res = new ArrayList<double[]>(relation.size());
        DoubleHistogram.Iter iter = hist.iter();
        while (iter.valid()) {
            res.add(new double[]{iter.getCenter(), iter.getValue()});
            iter.advance();
        }
        HistogramResult histogramResult = new HistogramResult("Ranking Quality Histogram", "ranking-histogram", (Collection<double[]>)res);
        histogramResult.addHeader("Mean: " + mv.getMean() + " Variance: " + mv.getSampleVariance());
        return histogramResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected int numbins = 20;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = (IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 100).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(param)) {
                this.numbins = (Integer)param.getValue();
            }
        }

        @Override
        protected RankingQualityHistogram<O> makeInstance() {
            return new RankingQualityHistogram(this.distanceFunction, this.numbins);
        }
    }
}

