/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.timeseries;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.timeseries.ChangePoints;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Title(value="Signi-Trend: scalable detection of emerging topics in textual streams by hashed significance thresholds")
@Reference(authors="Erich Schubert, Michael Weiler, Hans-Peter Kriegel", title="Signi-Trend: scalable detection of emerging topics in textual streams by hashed significance thresholds", booktitle="Proc. 20th ACM SIGKDD international conference on Knowledge discovery and data mining", url="https://doi.org/10.1145/2623330.2623740", bibkey="DBLP:conf/kdd/SchubertWK14")
@Priority(value=200)
public class SigniTrendChangeDetection
extends AbstractAlgorithm<ChangePoints> {
    private static final Logging LOG = Logging.getLogger(SigniTrendChangeDetection.class);
    private double alpha;
    private double bias;
    private double minsigma;

    public SigniTrendChangeDetection(double halflife, double bias, double minsigma) {
        this.alpha = 1.0 - FastMath.exp(FastMath.log(0.5) / halflife);
        this.bias = bias;
        this.minsigma = minsigma;
    }

    public ChangePoints run(Relation<NumberVector> relation) {
        return new Instance().run(relation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID HALFLIFE_ID = new OptionID("signitrend.halflife", "Half-life time: number of time steps until data has lost half its weight.");
        public static final OptionID BIAS_ID = new OptionID("signitrend.bias", "Adjustment for chance: a small constant corresponding to background noise levels.");
        public static final OptionID MINSIGMA_ID = new OptionID("signitrend.minsigma", "Significance threshold for reporting");
        private double halflife;
        private double bias;
        private double minsigma;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter minsigmaP;
            DoubleParameter biasP;
            super.makeOptions(config);
            DoubleParameter halflifeP = (DoubleParameter)new DoubleParameter(HALFLIFE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(halflifeP)) {
                this.halflife = halflifeP.doubleValue();
            }
            if (config.grab(biasP = (DoubleParameter)new DoubleParameter(BIAS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.bias = biasP.doubleValue();
            }
            if (config.grab(minsigmaP = (DoubleParameter)new DoubleParameter(MINSIGMA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.minsigma = (Double)minsigmaP.getValue();
            }
        }

        @Override
        protected SigniTrendChangeDetection makeInstance() {
            return new SigniTrendChangeDetection(this.halflife, this.bias, this.minsigma);
        }
    }

    protected class Instance {
        protected double[] ewma;
        protected double[] ewmv;
        protected double weight;

        public ChangePoints run(Relation<NumberVector> relation) {
            if (!(relation.getDBIDs() instanceof ArrayDBIDs)) {
                throw new AbortException("This implementation may only be used on static databases, with ArrayDBIDs to provide a clear order.");
            }
            ArrayDBIDs ids = (ArrayDBIDs)relation.getDBIDs();
            int dim = RelationUtil.dimensionality(relation);
            this.ewma = new double[dim];
            this.ewmv = new double[dim];
            this.weight = 0.0;
            ChangePoints changepoints = new ChangePoints("Signi-Trend Changepoints", "signitrend-changepoints");
            WritableDoubleDataStore vals = DataStoreUtil.makeDoubleStorage(ids, 30);
            DoubleMinMax mm = new DoubleMinMax();
            DBIDIter iter = relation.iterDBIDs();
            while (iter.valid()) {
                double absmax = this.processRow(iter, relation.get(iter), changepoints);
                vals.putDouble(iter, absmax);
                mm.put(absmax);
                iter.advance();
            }
            BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
            MaterializedDoubleRelation scores = new MaterializedDoubleRelation("Signi-Trend scores", "signitrend-scores", vals, relation.getDBIDs());
            changepoints.addChildResult(new OutlierResult(meta, scores));
            return changepoints;
        }

        private double processRow(DBIDRef iter, NumberVector row, ChangePoints changepoints) {
            if (!(this.weight > 0.0)) {
                for (int d = 0; d < row.getDimensionality(); ++d) {
                    double v = this.ewma[d] = row.doubleValue(d);
                    this.ewmv[d] = v * v;
                }
                this.weight = SigniTrendChangeDetection.this.alpha;
                return 0.0;
            }
            double alpha = SigniTrendChangeDetection.this.alpha;
            double minsigma = SigniTrendChangeDetection.this.minsigma;
            if (this.weight < 1.0) {
                double inc = (1.0 - this.weight) * alpha;
                alpha /= this.weight * (1.0 - alpha) + alpha;
                this.weight += inc;
            }
            double absmax = 0.0;
            for (int d = 0; d < row.getDimensionality(); ++d) {
                double var;
                double avg;
                double v = row.doubleValue(d);
                double sigma = (v - (avg = this.ewma[d])) / (FastMath.sqrt(var = this.ewmv[d]) + SigniTrendChangeDetection.this.bias);
                if (sigma >= minsigma || sigma <= -minsigma) {
                    changepoints.add(iter, d, sigma);
                }
                absmax = sigma > absmax ? sigma : (-sigma > absmax ? -sigma : absmax);
                double deli = v - avg;
                double inci = alpha * deli;
                int n = d;
                this.ewma[n] = this.ewma[n] + inci;
                this.ewmv[d] = (1.0 - alpha) * (var + inci * deli);
            }
            return absmax;
        }
    }
}

