/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;

public abstract class AbstractApplication {
    private static final Logging LOG = Logging.getLogger(AbstractApplication.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String VERSION;
    private static final String REFERENCE_VERSION = "0.7.5";
    @Reference(authors="Erich Schubert and Arthur Zimek", title="ELKI: A large open-source library for data analysis - ELKI Release 0.7.5 \"Heidelberg\"", booktitle="CoRR", url="https://arxiv.org/abs/1902.03616", bibkey="DBLP:journals/corr/abs-1902-03616")
    public static final String REFERENCE;

    public static void runCLIApplication(Class<?> cls, String[] args) {
        SerializedParameterization params = new SerializedParameterization(args);
        Flag helpF = new Flag(Parameterizer.HELP_ID);
        params.grab(helpF);
        Flag helpLongF = new Flag(Parameterizer.HELP_LONG_ID);
        params.grab(helpLongF);
        try {
            ClassParameter descriptionP = new ClassParameter(Parameterizer.DESCRIPTION_ID, Object.class, true);
            params.grab(descriptionP);
            if (descriptionP.isDefined()) {
                params.clearErrors();
                AbstractApplication.printDescription((Class)descriptionP.getValue());
                System.exit(1);
            }
            StringParameter debugP = (StringParameter)new StringParameter(Parameterizer.DEBUG_ID).setOptional(true);
            params.grab(debugP);
            if (debugP.isDefined()) {
                Parameterizer.parseDebugParameter(debugP);
            }
            if (params.getErrors().size() > 0) {
                params.logAndClearReportedErrors();
                System.exit(1);
            }
        }
        catch (Exception e) {
            AbstractApplication.printErrorMessage(e);
            System.exit(1);
        }
        try {
            TrackParameters config = new TrackParameters(params);
            Flag verboseF = new Flag(Parameterizer.VERBOSE_ID);
            if (config.grab(verboseF) && verboseF.isTrue()) {
                Flag verbose2F = new Flag(Parameterizer.VERBOSE_ID);
                LoggingConfiguration.setVerbose(config.grab(verbose2F) && verbose2F.isTrue() ? Logging.Level.VERYVERBOSE : Logging.Level.VERBOSE);
            }
            AbstractApplication task = ClassGenericsUtil.tryInstantiate(AbstractApplication.class, cls, config);
            if (helpF.isDefined() && ((Boolean)helpF.getValue()).booleanValue() || helpLongF.isDefined() && ((Boolean)helpLongF.getValue()).booleanValue()) {
                LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
                LOG.verbose(AbstractApplication.usage(config.getAllParameters()));
                System.exit(1);
            }
            if (params.getErrors().size() > 0) {
                LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
                LOG.verbose("ERROR: The following configuration errors prevented execution:");
                for (ParameterException e : params.getErrors()) {
                    LOG.verbose(e.getMessage() + "\n");
                }
                params.logUnusedParameters();
                LOG.verbose("Stopping execution because of configuration errors above.");
                System.exit(1);
            }
            params.logUnusedParameters();
            task.run();
        }
        catch (Exception e) {
            AbstractApplication.printErrorMessage(e);
        }
    }

    public static String usage(Collection<TrackedParameter> options) {
        StringBuilder usage = new StringBuilder(10000);
        if (!REFERENCE_VERSION.equals(VERSION)) {
            usage.append("ELKI build: ").append(VERSION).append(NEWLINE).append(NEWLINE);
        }
        usage.append(REFERENCE);
        OptionUtil.formatForConsole(usage.append(NEWLINE).append("Parameters:").append(NEWLINE), FormatUtil.getConsoleWidth(), options);
        return usage.toString();
    }

    protected static void printErrorMessage(Exception e) {
        if (e instanceof AbortException) {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
            LOG.verbose(e.getMessage());
        } else if (e instanceof UnspecifiedParameterException) {
            LOG.error(e.getMessage());
        } else if (e instanceof ParameterException) {
            LOG.error(e.getMessage());
        } else {
            LOG.exception(e);
        }
    }

    private static void printDescription(Class<?> descriptionClass) {
        if (descriptionClass == null) {
            return;
        }
        try {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
            LOG.verbose(OptionUtil.describeParameterizable(new StringBuilder(), descriptionClass, FormatUtil.getConsoleWidth(), "").toString());
        }
        catch (Exception e) {
            LOG.exception("Error instantiating class to describe.", e.getCause());
        }
    }

    public abstract void run();

    static {
        String version = "DEVELOPMENT";
        try {
            Properties prop = new Properties();
            prop.load(AbstractApplication.class.getClassLoader().getResourceAsStream("META-INF/elki.properties"));
            version = prop.getProperty("elki.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VERSION = version;
        REFERENCE = "ELKI Release 0.7.5 (2019, February) published in:" + NEWLINE + NEWLINE + "Erich Schubert and Arthur Zimek:" + NEWLINE + "ELKI: A large open-source library for data analysis - ELKI Release 0.7.5 \"Heidelberg\"." + NEWLINE + "CoRR arXiv:1902.03616" + NEWLINE;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUTPUT_ID = new OptionID("app.out", "");
        public static final OptionID INPUT_ID = new OptionID("app.in", "");
        public static final OptionID DATABASE_ID = new OptionID("db", "Database class.");
        public static final OptionID HELP_ID = new OptionID("h", "Request a help-message, either for the main-routine or for any specified algorithm. Causes immediate stop of the program.");
        public static final OptionID HELP_LONG_ID = new OptionID("help", "Request a help-message, either for the main-routine or for any specified algorithm. Causes immediate stop of the program.");
        public static final OptionID DESCRIPTION_ID = new OptionID("description", "Class to obtain a description of. Causes immediate stop of the program.");
        public static final OptionID DEBUG_ID = new OptionID("enableDebug", "Parameter to enable debugging for particular packages.");
        public static final OptionID VERBOSE_ID = new OptionID("verbose", "Enable verbose messages.");

        protected File getParameterOutputFile(Parameterization config) {
            return this.getParameterOutputFile(config, "Output filename.");
        }

        protected File getParameterOutputFile(Parameterization config, String description) {
            FileParameter outputP = new FileParameter(OUTPUT_ID, FileParameter.FileType.OUTPUT_FILE);
            outputP.setShortDescription(description);
            if (config.grab(outputP)) {
                return (File)outputP.getValue();
            }
            return null;
        }

        protected File getParameterInputFile(Parameterization config) {
            return this.getParameterInputFile(config, "Input filename.");
        }

        protected File getParameterInputFile(Parameterization config, String description) {
            FileParameter inputP = new FileParameter(INPUT_ID, FileParameter.FileType.INPUT_FILE);
            inputP.setShortDescription(description);
            if (config.grab(inputP)) {
                return (File)inputP.getValue();
            }
            return null;
        }

        public static final void parseDebugParameter(StringParameter param) throws WrongParameterValueException {
            String[] opts;
            for (String opt : opts = ((String)param.getValue()).split(",")) {
                try {
                    String[] chunks = opt.split("=");
                    if (chunks.length == 1) {
                        try {
                            Level level = Logging.Level.parse(chunks[0]);
                            LoggingConfiguration.setDefaultLevel(level);
                        }
                        catch (IllegalArgumentException e) {
                            LoggingConfiguration.setLevelFor(chunks[0], Logging.Level.FINEST.getName());
                        }
                        continue;
                    }
                    if (chunks.length == 2) {
                        LoggingConfiguration.setLevelFor(chunks[0], chunks[1]);
                        continue;
                    }
                    throw new WrongParameterValueException(param, (String)param.getValue(), "More than one '=' in debug parameter.");
                }
                catch (IllegalArgumentException e) {
                    throw new WrongParameterValueException(param, (String)param.getValue(), "Could not process value.", e);
                }
            }
        }

        @Override
        protected abstract AbstractApplication makeInstance();
    }
}

