/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleWriter;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class ConvertToBundleApplication
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ConvertToBundleApplication.class);
    private DatabaseConnection input;
    private File outfile;

    public ConvertToBundleApplication(DatabaseConnection input, File outfile) {
        this.input = input;
        this.outfile = outfile;
    }

    @Override
    public void run() {
        if (LOG.isVerbose()) {
            LOG.verbose("Loading data.");
        }
        MultipleObjectsBundle bundle = this.input.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose("Serializing to output file: " + this.outfile.toString());
        }
        BundleWriter writer = new BundleWriter();
        try {
            FileOutputStream fos = new FileOutputStream(this.outfile);
            FileChannel channel = fos.getChannel();
            writer.writeBundleStream(bundle.asStream(), channel);
            channel.close();
            fos.close();
        }
        catch (IOException e) {
            LOG.exception("IO Error", e);
        }
    }

    public static void main(String[] args) {
        ConvertToBundleApplication.runCLIApplication(ConvertToBundleApplication.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID DATABASE_CONNECTION_ID = new OptionID("dbc", "Database connection class.");
        private DatabaseConnection input;
        private File outfile;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter inputP = new ObjectParameter(DATABASE_CONNECTION_ID, (Class<?>)DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (config.grab(inputP)) {
                this.input = (DatabaseConnection)inputP.instantiateClass(config);
            }
            this.outfile = super.getParameterOutputFile(config, "File name to serialize the bundle to.");
        }

        @Override
        protected ConvertToBundleApplication makeInstance() {
            return new ConvertToBundleApplication(this.input, this.outfile);
        }
    }
}

