/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.application.KDDCLIApplication;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class ELKILauncher {
    public static final Class<? extends AbstractApplication> DEFAULT_APPLICATION;

    private ELKILauncher() {
    }

    public static void main(String[] args) {
        Class<AbstractApplication> cls;
        if (args.length > 0 && args[0].charAt(0) != '-' && (cls = ELKIServiceRegistry.findImplementation(AbstractApplication.class, args[0])) != null) {
            try {
                Method m = cls.getMethod("main", String[].class);
                String[] a = Arrays.copyOfRange(args, 1, args.length);
                m.invoke(null, new Object[]{a});
            }
            catch (InvocationTargetException e) {
                LoggingUtil.exception(e.getCause());
            }
            catch (Exception e) {
                LoggingUtil.exception(e);
            }
            return;
        }
        try {
            Method m = DEFAULT_APPLICATION.getMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            LoggingUtil.exception(e);
        }
    }

    static {
        Class clz = KDDCLIApplication.class;
        try {
            Class<?> minigui = Class.forName("de.lmu.ifi.dbs.elki.gui.minigui.MiniGUI");
            clz = minigui;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DEFAULT_APPLICATION = clz;
    }
}

