/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.datasource.GeneratorXMLDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GeneratorXMLSpec
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(GeneratorXMLSpec.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File outputFile;
    private GeneratorXMLDatabaseConnection generator;

    public GeneratorXMLSpec(File output, GeneratorXMLDatabaseConnection generator) {
        this.outputFile = output;
        this.generator = generator;
    }

    @Override
    public void run() {
        MultipleObjectsBundle data = this.generator.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose("Writing output ...");
        }
        try {
            if (this.outputFile.exists() && LOG.isVerbose()) {
                LOG.verbose("The file " + this.outputFile + " already exists, the generator result will be APPENDED.");
            }
            try (FileWriter outStream = new FileWriter(this.outputFile, true);){
                this.writeClusters(outStream, data);
            }
        }
        catch (IOException e) {
            throw new AbortException("IO Error in data generator.", e);
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Done.");
        }
    }

    public void writeClusters(OutputStreamWriter outStream, MultipleObjectsBundle data) throws IOException {
        int modelcol = -1;
        for (int i = 0; i < data.metaLength(); ++i) {
            if (!Model.TYPE.isAssignableFromType(data.meta(i))) continue;
            modelcol = i;
            break;
        }
        if (modelcol < 0) {
            throw new AbortException("No model column found in bundle.");
        }
        ArrayList<Model> models = new ArrayList<Model>();
        HashMap<Model, Object> modelMap = new HashMap<Model, Object>();
        for (int i = 0; i < data.dataLength(); ++i) {
            Model model = (Model)data.data(i, modelcol);
            Object modelids = (IntArrayList)modelMap.get(model);
            if (modelids == null) {
                models.add(model);
                modelids = new IntArrayList();
                modelMap.put(model, modelids);
            }
            ((IntArrayList)modelids).add(i);
        }
        int totalsize = 0;
        int totaldisc = 0;
        for (Map.Entry entry : modelMap.entrySet()) {
            totalsize += ((IntArrayList)entry.getValue()).size();
            if (!(entry.getKey() instanceof GeneratorSingleCluster)) continue;
            totaldisc += ((GeneratorSingleCluster)entry.getKey()).getDiscarded();
        }
        double globdens = (double)(totalsize + totaldisc) / (double)totalsize;
        outStream.append("########################################################").append(LINE_SEPARATOR);
        outStream.append("## Number of clusters: " + models.size()).append(LINE_SEPARATOR);
        for (Model model : models) {
            IntArrayList ids = (IntArrayList)modelMap.get(model);
            outStream.append("########################################################").append(LINE_SEPARATOR);
            outStream.append("## Size: " + ids.size()).append(LINE_SEPARATOR);
            if (model instanceof GeneratorSingleCluster) {
                GeneratorSingleCluster cursclus = (GeneratorSingleCluster)((Object)model);
                outStream.append("########################################################").append(LINE_SEPARATOR);
                outStream.append("## Cluster: ").append(cursclus.getName()).append(LINE_SEPARATOR);
                double[] cmin = cursclus.getClipmin();
                double[] cmax = cursclus.getClipmax();
                if (cmin != null && cmax != null) {
                    outStream.append("## Clipping: ").append(FormatUtil.format(cmin)).append(" - ").append(FormatUtil.format(cmax)).append(LINE_SEPARATOR);
                }
                outStream.append("## Density correction factor: " + cursclus.getDensityCorrection()).append(LINE_SEPARATOR);
                outStream.append("## Generators:").append(LINE_SEPARATOR);
                for (int i = 0; i < cursclus.getDim(); ++i) {
                    Distribution gen = cursclus.getDistribution(i);
                    outStream.append("##   ").append(gen.toString()).append(LINE_SEPARATOR);
                }
                if (cursclus.getTransformation() != null && cursclus.getTransformation().getTransformation() != null) {
                    outStream.append("## Affine transformation matrix:").append(LINE_SEPARATOR);
                    outStream.append(FormatUtil.format(cursclus.getTransformation().getTransformation(), "## ")).append(LINE_SEPARATOR);
                }
                outStream.append("## Discards: " + cursclus.getDiscarded() + " Retries left: " + cursclus.getRetries()).append(LINE_SEPARATOR);
                double corf = (double)(cursclus.getSize() + cursclus.getDiscarded()) / (double)cursclus.getSize() / globdens;
                outStream.append("## Density correction factor estimation: " + corf).append(LINE_SEPARATOR);
            }
            outStream.append("########################################################").append(LINE_SEPARATOR);
            IntListIterator iter = ids.iterator();
            while (iter.hasNext()) {
                int num = iter.nextInt();
                for (int c = 0; c < data.metaLength(); ++c) {
                    if (c == modelcol) continue;
                    if (c > 0) {
                        outStream.append(' ');
                    }
                    outStream.append(data.data(num, c).toString());
                }
                outStream.append(LINE_SEPARATOR);
            }
        }
    }

    public static void main(String[] args) {
        GeneratorXMLSpec.runCLIApplication(GeneratorXMLSpec.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        private File outputFile = null;
        private GeneratorXMLDatabaseConnection generator = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.generator = config.tryInstantiate(GeneratorXMLDatabaseConnection.class);
            this.outputFile = this.getParameterOutputFile(config, "The file to write the generated data set into, if the file already exists, the generated points will be appended to this file.");
        }

        @Override
        protected GeneratorXMLSpec makeInstance() {
            return new GeneratorXMLSpec(this.outputFile, this.generator);
        }
    }
}

