/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.cache;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.StaticArrayDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class CacheDoubleDistanceRangeQueries<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceRangeQueries.class);
    private Database database;
    private DistanceFunction<? super O> distance;
    private double radius;
    private File out;
    public static final int RANGE_CACHE_MAGIC = -893111501;

    public CacheDoubleDistanceRangeQueries(Database database, DistanceFunction<? super O> distance, double radius, File out) {
        this.database = database;
        this.distance = distance;
        this.radius = radius;
        this.out = out;
    }

    @Override
    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<? super O> distanceQuery = this.database.getDistanceQuery(relation, this.distance, new Object[0]);
        RangeQuery<O> rangeQ = this.database.getRangeQuery(distanceQuery, this.radius, "heavy");
        LOG.verbose("Performing range queries with radius " + this.radius);
        try (RandomAccessFile file = new RandomAccessFile(this.out, "rw");
             FileChannel channel = file.getChannel();
             FileLock lock = channel.lock();){
            file.writeInt(-893111501);
            file.writeDouble(this.radius);
            int bufsize = 2410;
            ByteBuffer buffer = ByteBuffer.allocateDirect(bufsize);
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing range queries", relation.size(), LOG) : null;
            ModifiableDoubleDBIDList nn = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter ni = nn.iter();
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                nn.clear();
                rangeQ.getRangeForDBID(it, this.radius, nn);
                nn.sort();
                int nnsize = nn.size();
                if (nnsize * 12 + 10 > bufsize) {
                    while (nnsize * 12 + 10 > bufsize) {
                        bufsize <<= 1;
                    }
                    LOG.verbose("Resizing buffer to " + bufsize + " to store " + nnsize + " results:");
                    buffer = ByteBuffer.allocateDirect(bufsize);
                }
                buffer.clear();
                ByteArrayUtil.writeUnsignedVarint(buffer, it.internalGetIndex());
                ByteArrayUtil.writeUnsignedVarint(buffer, nnsize);
                int c = 0;
                ni.seek(0);
                while (ni.valid()) {
                    ByteArrayUtil.writeUnsignedVarint(buffer, ni.internalGetIndex());
                    buffer.putDouble(ni.doubleValue());
                    ni.advance();
                    ++c;
                }
                if (c != nn.size()) {
                    throw new AbortException("Sizes did not agree. Cache is invalid.");
                }
                buffer.flip();
                channel.write(buffer);
                LOG.incrementProcessed(prog);
                it.advance();
            }
            LOG.ensureCompleted(prog);
            lock.release();
        }
        catch (IOException e) {
            LOG.exception(e);
        }
    }

    public static void main(String[] args) {
        CacheDoubleDistanceRangeQueries.runCLIApplication(CacheDoubleDistanceRangeQueries.class, args);
    }

    public static class Parameterizer<O>
    extends AbstractApplication.Parameterizer {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        public static final OptionID RADIUS_ID = new OptionID("loader.radius", "Query radius for precomputation.");
        private Database database = null;
        private DistanceFunction<? super O> distance = null;
        private double radius;
        private File out = null;

        @Override
        protected void makeOptions(Parameterization config) {
            FileParameter cpar;
            DoubleParameter kpar;
            ObjectParameter dpar;
            super.makeOptions(config);
            ObjectParameter dbP = new ObjectParameter(DATABASE_ID, (Class<?>)Database.class, StaticArrayDatabase.class);
            if (config.grab(dbP)) {
                this.database = (Database)dbP.instantiateClass(config);
            }
            if (config.grab(dpar = new ObjectParameter(DISTANCE_ID, DistanceFunction.class))) {
                this.distance = (DistanceFunction)dpar.instantiateClass(config);
            }
            if (config.grab(kpar = (DoubleParameter)new DoubleParameter(RADIUS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.radius = kpar.doubleValue();
            }
            if (config.grab(cpar = new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE))) {
                this.out = (File)cpar.getValue();
            }
        }

        @Override
        protected CacheDoubleDistanceRangeQueries<O> makeInstance() {
            return new CacheDoubleDistanceRangeQueries<O>(this.database, this.distance, this.radius, this.out);
        }
    }
}

