/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.cache;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.StaticArrayDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class PrecomputeDistancesAsciiApplication<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(PrecomputeDistancesAsciiApplication.class);
    public static final String GZIP_POSTFIX = ".gz";
    private boolean debugExtraCheckSymmetry = false;
    private Database database;
    private DistanceFunction<? super O> distance;
    private File out;

    public PrecomputeDistancesAsciiApplication(Database database, DistanceFunction<? super O> distance, File out) {
        this.database = database;
        this.distance = distance;
        this.out = out;
    }

    @Override
    public void run() {
        this.database.initialize();
        Relation relation = this.database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<O> distanceQuery = this.database.getDistanceQuery(relation, this.distance, new Object[0]);
        DBIDRange ids = DBIDUtil.assertRange(relation.getDBIDs());
        int size = ids.size();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing distances", (int)((long)(size - 1) * (long)size >>> 1), LOG) : null;
        try (PrintStream fout = PrecomputeDistancesAsciiApplication.openStream(this.out);){
            DBIDArrayIter id1 = ids.iter();
            DBIDArrayIter id2 = ids.iter();
            while (id1.valid()) {
                String idstr1 = Integer.toString(id1.getOffset());
                if (this.debugExtraCheckSymmetry && distanceQuery.distance((DBIDRef)id1, (DBIDRef)id1) != 0.0) {
                    LOG.warning("Distance function doesn't satisfy d(0,0) = 0.");
                }
                id2.seek(id1.getOffset() + 1);
                while (id2.valid()) {
                    double d2;
                    double d = distanceQuery.distance((DBIDRef)id1, (DBIDRef)id2);
                    if (this.debugExtraCheckSymmetry && Math.abs(d - (d2 = distanceQuery.distance((DBIDRef)id2, (DBIDRef)id1))) > 1.0E-7) {
                        LOG.warning("Distance function doesn't appear to be symmetric!");
                    }
                    fout.append(idstr1).append('\t').append(Integer.toString(id2.getOffset())).append('\t').append(Double.toString(d)).append('\n');
                    id2.advance();
                }
                if (prog != null) {
                    prog.setProcessed(prog.getProcessed() + (size - id1.getOffset() - 1), LOG);
                }
                id1.advance();
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not write to output file.", e);
        }
        LOG.ensureCompleted(prog);
    }

    private static PrintStream openStream(File out) throws IOException {
        FileOutputStream os = new FileOutputStream(out);
        os = out.getName().endsWith(GZIP_POSTFIX) ? new GZIPOutputStream(os) : os;
        return new PrintStream(os);
    }

    public static void main(String[] args) {
        PrecomputeDistancesAsciiApplication.runCLIApplication(PrecomputeDistancesAsciiApplication.class, args);
    }

    public static class Parameterizer<O>
    extends AbstractApplication.Parameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        private Database database = null;
        private DistanceFunction<? super O> distance = null;
        private File out = null;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter dpar;
            super.makeOptions(config);
            ObjectParameter dbP = new ObjectParameter(DATABASE_ID, (Class<?>)Database.class, StaticArrayDatabase.class);
            if (config.grab(dbP)) {
                this.database = (Database)dbP.instantiateClass(config);
            }
            if (config.grab(dpar = new ObjectParameter(DISTANCE_ID, DistanceFunction.class))) {
                this.distance = (DistanceFunction)dpar.instantiateClass(config);
            }
            this.out = this.getParameterOutputFile(config);
        }

        @Override
        protected PrecomputeDistancesAsciiApplication<O> makeInstance() {
            return new PrecomputeDistancesAsciiApplication<O>(this.database, this.distance, this.out);
        }
    }
}

