/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.experiments;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.GEDEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.HillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.LMomentsEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.MOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.PWM2Estimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.PWMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.RVEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.ZipfEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import net.jafama.FastMath;

public class EvaluateIntrinsicDimensionalityEstimators
extends AbstractApplication {
    int startk = 3;
    int maxk = 10;
    int samples = 1000;
    int dim = 5;
    Aggregate agg;
    OutputFormat format;
    RandomFactory rnd;

    public EvaluateIntrinsicDimensionalityEstimators(int startk, int maxk, int samples, int dim, Aggregate agg, OutputFormat format, RandomFactory rnd) {
        this.startk = startk;
        this.maxk = maxk;
        this.samples = samples;
        this.dim = dim;
        this.agg = agg;
        this.format = format;
        this.rnd = rnd;
    }

    @Override
    public void run() {
        ArrayList<String> abbreviat = new ArrayList<String>();
        ArrayList<IntrinsicDimensionalityEstimator> estimators = new ArrayList<IntrinsicDimensionalityEstimator>();
        abbreviat.add("Hill");
        estimators.add(HillEstimator.STATIC);
        abbreviat.add("MoM");
        estimators.add(MOMEstimator.STATIC);
        abbreviat.add("RV");
        estimators.add(RVEstimator.STATIC);
        abbreviat.add("AggHi");
        estimators.add(AggregatedHillEstimator.STATIC);
        abbreviat.add("Zipf");
        estimators.add(ZipfEstimator.STATIC);
        abbreviat.add("GED");
        estimators.add(GEDEstimator.STATIC);
        abbreviat.add("LMM");
        estimators.add(LMomentsEstimator.STATIC);
        abbreviat.add("PWM");
        estimators.add(PWMEstimator.STATIC);
        abbreviat.add("PWM2");
        estimators.add(PWM2Estimator.STATIC);
        PrintStream out = System.out;
        int digits = (int)FastMath.ceil(FastMath.log10(this.maxk + 1));
        switch (this.format) {
            case TABULAR: {
                int i;
                out.append(String.format("%" + digits + "s", "k"));
                for (i = 0; i < estimators.size(); ++i) {
                    for (String postfix : this.agg.description()) {
                        out.format(Locale.ROOT, " %10s", (String)abbreviat.get(i) + "-" + postfix);
                    }
                }
                out.append(FormatUtil.NEWLINE);
                break;
            }
            case TSV: {
                int i;
                out.append("k");
                for (i = 0; i < estimators.size(); ++i) {
                    for (String postfix : this.agg.description()) {
                        out.append('\t').append((CharSequence)abbreviat.get(i)).append('-').append(postfix);
                    }
                }
                out.append(FormatUtil.NEWLINE);
            }
        }
        double[][] v = new double[estimators.size()][this.samples];
        block12: for (int l = this.startk; l <= this.maxk; ++l) {
            for (int p = 0; p < this.samples; ++p) {
                double[] dists = this.makeSample(l);
                for (int i = 0; i < estimators.size(); ++i) {
                    IntrinsicDimensionalityEstimator est = (IntrinsicDimensionalityEstimator)estimators.get(i);
                    v[i][p] = est.estimate(dists, l);
                }
            }
            switch (this.format) {
                case TABULAR: {
                    int i;
                    out.append(String.format("%0" + digits + "d", l));
                    for (i = 0; i < estimators.size(); ++i) {
                        for (double val : this.agg.aggregate(v[i])) {
                            out.format(Locale.ROOT, " %10f", val);
                        }
                    }
                    out.append(FormatUtil.NEWLINE);
                    continue block12;
                }
                case TSV: {
                    int i;
                    out.append(FormatUtil.NF.format(l));
                    for (i = 0; i < estimators.size(); ++i) {
                        for (double val : this.agg.aggregate(v[i])) {
                            out.append('\t');
                            out.append(FormatUtil.NF.format(val));
                        }
                    }
                    out.append(FormatUtil.NEWLINE);
                }
            }
        }
    }

    protected double[] makeSample(int maxk) {
        Random rnd = this.rnd.getSingleThreadedRandom();
        double[] dists = new double[maxk + 1];
        double e = 1.0 / (double)this.dim;
        for (int i = 0; i <= maxk; ++i) {
            dists[i] = FastMath.pow(rnd.nextDouble(), e);
        }
        Arrays.sort(dists);
        return dists;
    }

    public static void main(String[] args) {
        EvaluateIntrinsicDimensionalityEstimators.runCLIApplication(EvaluateIntrinsicDimensionalityEstimators.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID STARTK_ID = new OptionID("mink", "Minimum value of k.");
        public static final OptionID MAXK_ID = new OptionID("maxk", "Maximum value of k.");
        public static final OptionID SAMPLE_ID = new OptionID("sample", "Sample size for averaging.");
        public static final OptionID DIM_ID = new OptionID("dim", "Dimensionality.");
        public static final OptionID SEED_ID = new OptionID("seed", "Random seed.");
        public static final OptionID AGGREGATE_ID = new OptionID("aggregation", "Aggregation method.");
        public static final OptionID FORMAT_ID = new OptionID("output-format", "Output format (ascii, or tab separated).");
        int startk = 3;
        int maxk = 10;
        int samples = 1000;
        int dim = 5;
        Aggregate agg;
        OutputFormat format;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<OutputFormat> formatP;
            EnumParameter<Aggregate> aggP;
            IntParameter dimP;
            RandomParameter seedP;
            IntParameter samplesP;
            IntParameter maxkP;
            super.makeOptions(config);
            IntParameter startP = (IntParameter)new IntParameter(STARTK_ID, 3).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(startP)) {
                this.startk = startP.intValue();
            }
            if (config.grab(maxkP = (IntParameter)new IntParameter(MAXK_ID, 20).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.maxk = maxkP.intValue();
            }
            if (config.grab(samplesP = (IntParameter)new IntParameter(SAMPLE_ID, 1000).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.samples = samplesP.intValue();
            }
            if (config.grab(seedP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)seedP.getValue();
            }
            if (config.grab(dimP = (IntParameter)new IntParameter(DIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.dim = dimP.intValue();
            }
            if (config.grab(aggP = new EnumParameter<Aggregate>(AGGREGATE_ID, Aggregate.class, Aggregate.MED_MAD))) {
                this.agg = (Aggregate)((Object)aggP.getValue());
            }
            if (config.grab(formatP = new EnumParameter<OutputFormat>(FORMAT_ID, OutputFormat.class, OutputFormat.TABULAR))) {
                this.format = (OutputFormat)((Object)formatP.getValue());
            }
        }

        @Override
        protected EvaluateIntrinsicDimensionalityEstimators makeInstance() {
            return new EvaluateIntrinsicDimensionalityEstimators(this.startk, this.maxk, this.samples, this.dim, this.agg, this.format, this.rnd);
        }
    }

    static enum Aggregate {
        MEAN{

            @Override
            double[] aggregate(double[] data) {
                double avg = 0.0;
                for (double val : data) {
                    avg += val;
                }
                return new double[]{avg / (double)data.length};
            }

            @Override
            String[] description() {
                return new String[]{"Mean"};
            }
        }
        ,
        MEAN_STDDEV{

            @Override
            double[] aggregate(double[] data) {
                double avg = 0.0;
                for (double val : data) {
                    avg += val;
                }
                avg /= (double)data.length;
                double sqsum = 0.0;
                for (double val : data) {
                    double v = val - avg;
                    sqsum += v * v;
                }
                return new double[]{avg, FastMath.sqrt(sqsum /= (double)data.length)};
            }

            @Override
            String[] description() {
                return new String[]{"Mean", "Stddev"};
            }
        }
        ,
        MEAN_STDDEV_MIN_MAX{

            @Override
            double[] aggregate(double[] data) {
                double avg = 0.0;
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (double val : data) {
                    avg += val;
                    min = val < min ? val : min;
                    max = val > max ? val : max;
                }
                avg /= (double)data.length;
                double sqsum = 0.0;
                for (double val : data) {
                    double v = val - avg;
                    sqsum += v * v;
                }
                return new double[]{avg, FastMath.sqrt(sqsum /= (double)data.length), min, max};
            }

            @Override
            String[] description() {
                return new String[]{"Mean", "Stddev", "Min", "Max"};
            }
        }
        ,
        HMEAN{

            @Override
            double[] aggregate(double[] data) {
                double avg = 0.0;
                for (double val : data) {
                    avg += 1.0 / val;
                }
                return new double[]{(double)data.length / avg};
            }

            @Override
            String[] description() {
                return new String[]{"HMean"};
            }
        }
        ,
        MEDIAN{

            @Override
            double[] aggregate(double[] data) {
                double med = QuickSelect.median(data);
                return new double[]{med};
            }

            @Override
            String[] description() {
                return new String[]{"Median"};
            }
        }
        ,
        MED_MAD{

            @Override
            double[] aggregate(double[] data) {
                double med = QuickSelect.median(data);
                double[] devs = new double[data.length];
                for (int i = 0; i < data.length; ++i) {
                    devs[i] = Math.abs(data[i] - med);
                }
                double mad = QuickSelect.median(devs);
                return new double[]{med, mad};
            }

            @Override
            String[] description() {
                return new String[]{"Med", "Mad"};
            }
        }
        ,
        MED_MAD_MIN_MAX{

            @Override
            double[] aggregate(double[] data) {
                double med = QuickSelect.median(data);
                double[] devs = new double[data.length];
                double min = med;
                double max = med;
                for (int i = 0; i < data.length; ++i) {
                    double v = data[i];
                    min = v < min ? v : min;
                    max = v > max ? v : max;
                    devs[i] = Math.abs(v - med);
                }
                double mad = QuickSelect.median(devs);
                return new double[]{med, mad, min, max};
            }

            @Override
            String[] description() {
                return new String[]{"Med", "Mad", "Min", "Max"};
            }
        }
        ,
        QUANTILES{

            @Override
            double[] aggregate(double[] data) {
                double[] quants = new double[]{0.0, 0.1, 0.25, 0.5, 0.75, 0.9, 1.0};
                int l = data.length;
                Arrays.sort(data);
                double[] ret = new double[quants.length];
                for (int i = 0; i < quants.length; ++i) {
                    double dleft = (double)(l - 1) * quants[i];
                    int ileft = (int)FastMath.floor(dleft);
                    double err = dleft - (double)ileft;
                    ret[i] = err < Double.MIN_NORMAL ? data[ileft] : data[ileft] + (data[ileft + 1] - data[ileft]) * err;
                }
                return ret;
            }

            @Override
            String[] description() {
                return new String[]{"Min", "Q10", "Q25", "Med", "Q75", "Q90", "Max"};
            }
        };


        abstract double[] aggregate(double[] var1);

        abstract String[] description();
    }

    static enum OutputFormat {
        TABULAR,
        TSV;

    }
}

