/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.experiments;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphereUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.jafama.FastMath;

@Alias(value={"de.lmu.ifi.dbs.elki.application.geo.VisualizeGeodesicDistances"})
@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class VisualizeGeodesicDistances
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(VisualizeGeodesicDistances.class);
    private File out;
    protected int width = 2000;
    protected int height = 1000;
    protected int steps = 10;
    protected Mode mode = Mode.XTD;
    protected EarthModel model;

    public VisualizeGeodesicDistances(File out, int resolution, int steps, Mode mode, EarthModel model) {
        this.width = resolution;
        this.height = resolution >> 1;
        this.out = out;
        this.steps = steps;
        this.mode = mode;
        this.model = model;
    }

    @Override
    public void run() {
        DoubleVector stap = DoubleVector.wrap(new double[]{48.133333, 11.566667});
        DoubleVector endp = DoubleVector.wrap(new double[]{40.712778, -74.005833});
        ModifiableHyperBoundingBox bb = new ModifiableHyperBoundingBox(new double[]{47.2701115, 8.9763497}, new double[]{50.5647142, 13.8396371});
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        double max = this.model.getEquatorialRadius() * Math.PI;
        int red = -65536;
        int green = -16711936;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("columns", this.width, LOG) : null;
        for (int x = 0; x < this.width; ++x) {
            double lon = (double)x * 360.0 / (double)this.width - 180.0;
            block8: for (int y = 0; y < this.height; ++y) {
                double lat = (double)y * -180.0 / (double)this.height + 90.0;
                switch (this.mode) {
                    case ATD: {
                        double atd = this.model.getEquatorialRadius() * SphereUtil.alongTrackDistanceDeg(stap.doubleValue(0), stap.doubleValue(1), endp.doubleValue(0), endp.doubleValue(1), lat, lon);
                        if (atd < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -atd / max, false));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, atd / max, false));
                        continue block8;
                    }
                    case XTD: {
                        double ctd = this.model.getEquatorialRadius() * SphereUtil.crossTrackDistanceDeg(stap.doubleValue(0), stap.doubleValue(1), endp.doubleValue(0), endp.doubleValue(1), lat, lon);
                        if (ctd < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -ctd / max, false));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, ctd / max, false));
                        continue block8;
                    }
                    case MINDIST: {
                        double dist = this.model.minDistDeg(lat, lon, bb.getMin(0), bb.getMin(1), bb.getMax(0), bb.getMax(1));
                        if (dist < 0.0) {
                            img.setRGB(x, y, this.colorMultiply(red, -dist / max, true));
                            continue block8;
                        }
                        img.setRGB(x, y, this.colorMultiply(green, dist / max, true));
                        continue block8;
                    }
                }
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        try {
            ImageIO.write((RenderedImage)img, "png", this.out);
        }
        catch (IOException e) {
            LOG.exception(e);
        }
    }

    private int colorMultiply(int col, double reldist, boolean ceil) {
        double factor;
        double s;
        double off;
        if (this.steps > 0) {
            reldist = !ceil ? (double)(FastMath.round(reldist * (double)this.steps) / (long)this.steps) : FastMath.ceil(reldist * (double)this.steps) / (double)this.steps;
        } else if (this.steps < 0 && reldist > 0.0 && (off = Math.abs((s = reldist * (double)(-this.steps)) - (double)FastMath.round(s))) < (factor = (double)(-this.steps) * 1.0 / 1000.0)) {
            factor = off / factor;
            int a = col >> 24 & 0xFF;
            a = (int)((double)a * FastMath.sqrt(reldist)) & 0xFF;
            a = (int)((1.0 - factor) * 255.0 + factor * (double)a);
            int r = (int)(factor * (double)(col >> 16 & 0xFF));
            int g = (int)(factor * (double)(col >> 8 & 0xFF));
            int b = (int)(factor * (double)(col & 0xFF));
            return a << 24 | r << 16 | g << 8 | b;
        }
        int a = col >> 24 & 0xFF;
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        a = (int)((double)a * FastMath.sqrt(reldist)) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void main(String[] args) {
        VisualizeGeodesicDistances.runCLIApplication(VisualizeGeodesicDistances.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID STEPS_ID = new OptionID("geodistvis.steps", "Number of steps for the distance map. Use negative numbers to get contour lines.");
        public static final OptionID RESOLUTION_ID = new OptionID("geodistvis.resolution", "Horizontal resolution for the image map (vertical resolution is horizonal / 2).");
        public static final OptionID MODE_ID = new OptionID("geodistvis.mode", "Visualization mode.");
        protected File out = null;
        protected int steps = 0;
        protected int resolution = 2000;
        protected Mode mode = Mode.XTD;
        protected EarthModel model;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter modelP;
            EnumParameter<Mode> modeP;
            IntParameter resolutionP;
            super.makeOptions(config);
            this.out = super.getParameterOutputFile(config, "Output image file name.");
            IntParameter stepsP = (IntParameter)new IntParameter(STEPS_ID).setOptional(true);
            if (config.grab(stepsP)) {
                this.steps = stepsP.intValue();
            }
            if (config.grab(resolutionP = new IntParameter(RESOLUTION_ID, 2000))) {
                this.resolution = resolutionP.intValue();
            }
            if (config.grab(modeP = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.XTD))) {
                this.mode = (Mode)((Object)modeP.getValue());
            }
            if (config.grab(modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class))) {
                this.model = (EarthModel)modelP.instantiateClass(config);
            }
        }

        @Override
        protected VisualizeGeodesicDistances makeInstance() {
            return new VisualizeGeodesicDistances(this.out, this.resolution, this.steps, this.mode, this.model);
        }
    }

    public static enum Mode {
        XTD,
        ATD,
        MINDIST;

    }
}

