/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.DWOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.FastABOD;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNDD;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNSOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNWeightOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.LocalIsolationCoefficient;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.ODIN;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.IDOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.ISOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.IntrinsicDimensionalityOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.COF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.INFLO;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.KDEOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LDF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LDOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LoOP;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.SimpleKernelDensityLOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.SimplifiedLOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.VarianceOfVolume;
import de.lmu.ifi.dbs.elki.algorithm.outlier.trivial.ByLabelOutlier;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.range.IntGenerator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntGeneratorParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import net.jafama.FastMath;

@Reference(authors="Erich Schubert, Remigius Wojdanowski, Arthur Zimek, Hans-Peter Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM Int. Conf. on Data Mining (SDM 2012)", url="https://doi.org/10.1137/1.9781611972825.90", bibkey="DBLP:conf/sdm/SchubertWZK12")
public class ComputeKNNOutlierScores<O extends NumberVector>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ComputeKNNOutlierScores.class);
    final InputStep inputstep;
    final DistanceFunction<? super O> distf;
    final IntGenerator krange;
    File outfile;
    ByLabelOutlier bylabel;
    ScalingFunction scaling;
    Pattern disable = null;
    int ksquarestop = 1000;

    public ComputeKNNOutlierScores(InputStep inputstep, DistanceFunction<? super O> distf, IntGenerator krange, ByLabelOutlier bylabel, File outfile, ScalingFunction scaling, Pattern disable, int ksquarestop) {
        this.distf = distf;
        this.krange = krange;
        this.inputstep = inputstep;
        this.bylabel = bylabel;
        this.outfile = outfile;
        this.scaling = scaling;
        this.disable = disable;
        this.ksquarestop = ksquarestop;
    }

    @Override
    public void run() {
        int maxk;
        int lim;
        Database database = this.inputstep.getDatabase();
        Relation relation = database.getRelation(this.distf.getInputTypeRestriction(), new Object[0]);
        KNNQuery<O> knnq = QueryUtil.getKNNQuery(relation, this.distf, lim = Math.min((maxk = Math.min(this.krange.getMax(), relation.size() - 1)) + 2, relation.size()));
        if (!(knnq instanceof PreprocessorKNNQuery)) {
            MaterializeKNNPreprocessor<O> preproc = new MaterializeKNNPreprocessor<O>(relation, this.distf, lim);
            preproc.initialize();
            relation.getHierarchy().add(relation, preproc);
        }
        if (!((knnq = QueryUtil.getKNNQuery(relation, this.distf, lim)) instanceof PreprocessorKNNQuery)) {
            throw new AbortException("Not using preprocessor knn query -- KNN queries using class: " + knnq.getClass());
        }
        int maxksq = Math.min(maxk, this.ksquarestop);
        if (!this.isDisabled("FastABOD") && maxksq > 1000) {
            LOG.warning("Note: FastABOD needs quadratic memory. Use -" + Parameterizer.DISABLE_ID.getName() + " FastABOD to disable.");
        }
        if (!this.isDisabled("LDOF") && maxksq > 1000) {
            LOG.verbose("Note: LODF needs O(k^2) distance computations. Use -" + Parameterizer.DISABLE_ID.getName() + " LDOF to disable.");
        }
        if (!this.isDisabled("DWOF") && maxksq > 1000) {
            LOG.warning("Note: DWOF needs O(k^2) distance computations. Use -" + Parameterizer.DISABLE_ID.getName() + " DWOF to disable.");
        }
        if (!this.isDisabled("COF") && maxksq > 1000) {
            LOG.warning("Note: COF needs O(k^2) distance computations. Use -" + Parameterizer.DISABLE_ID.getName() + " COF to disable.");
        }
        DBIDs ids = relation.getDBIDs();
        try (PrintStream fout = new PrintStream(this.outfile);){
            fout.append("# Data set size: " + relation.size()).append(" data type: " + relation.getDataTypeInformation()).append(FormatUtil.NEWLINE);
            this.writeResult(fout, ids, this.bylabel.run(database), new IdentityScaling(), "bylabel");
            BiConsumer<String, OutlierResult> out = (kstr, result) -> this.writeResult(fout, ids, (OutlierResult)result, this.scaling, (String)kstr);
            this.runForEachK("KNN", 0, maxk, k -> new KNNOutlier<O>(this.distf, k).run(database, relation), out);
            this.runForEachK("KNNW", 0, maxk, k -> new KNNWeightOutlier<O>(this.distf, k).run(database, relation), out);
            this.runForEachK("LOF", 0, maxk, k -> new LOF<O>(k, this.distf).run(database, relation), out);
            this.runForEachK("SimplifiedLOF", 0, maxk, k -> new SimplifiedLOF<O>(k, this.distf).run(database, relation), out);
            this.runForEachK("LoOP", 0, maxk, k -> new LoOP<O>(k, k, this.distf, this.distf, 1.0).run(database, relation), out);
            this.runForEachK("LDOF", 2, maxksq, k -> new LDOF<O>(this.distf, k).run(database, relation), out);
            this.runForEachK("ODIN", 0, maxk, k -> new ODIN<O>(this.distf, k).run(database, relation), out);
            this.runForEachK("FastABOD", 3, maxksq, k -> new FastABOD<NumberVector>(LinearKernelFunction.STATIC, k).run(database, relation), out);
            this.runForEachK("KDEOS", 2, maxk, k -> new KDEOS<O>(this.distf, k, k, GaussianKernelDensityFunction.KERNEL, 0.0, 0.5 * GaussianKernelDensityFunction.KERNEL.canonicalBandwidth(), 2).run(database, relation), out);
            this.runForEachK("LDF", 0, maxk, k -> new LDF<O>(k, this.distf, GaussianKernelDensityFunction.KERNEL, 1.0, 0.1).run(database, relation), out);
            this.runForEachK("INFLO", 0, maxk, k -> new INFLO<O>(this.distf, 1.0, k).run(database, relation), out);
            this.runForEachK("COF", 0, maxksq, k -> new COF<O>(k, this.distf).run(database, relation), out);
            this.runForEachK("Intrinsic", 2, maxk, k -> new IntrinsicDimensionalityOutlier<O>(this.distf, k, AggregatedHillEstimator.STATIC).run(database, relation), out);
            this.runForEachK("IDOS", 2, maxk, k -> new IDOS<O>(this.distf, AggregatedHillEstimator.STATIC, k, k).run(database, relation), out);
            this.runForEachK("KDLOF", 2, maxk, k -> new SimpleKernelDensityLOF<O>(k, this.distf, GaussianKernelDensityFunction.KERNEL).run(database, relation), out);
            this.runForEachK("DWOF", 2, maxksq, k -> new DWOF<O>(this.distf, k, 1.1).run(database, relation), out);
            this.runForEachK("LIC", 0, maxk, k -> new LocalIsolationCoefficient<O>(this.distf, k).run(database, relation), out);
            if (TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                DistanceFunction df = this.distf;
                Relation rel = relation;
                this.runForEachK("VOV", 0, maxk, k -> new VarianceOfVolume(k, df).run(database, rel), out);
            }
            this.runForEachK("KNNDD", 0, maxk, k -> new KNNDD<O>(this.distf, k).run(database, relation), out);
            this.runForEachK("KNNSOS", 0, maxk, k -> new KNNSOS<O>(this.distf, k).run(relation), out);
            this.runForEachK("ISOS", 2, maxk, k -> new ISOS<O>(this.distf, k, AggregatedHillEstimator.STATIC).run(relation), out);
        }
        catch (FileNotFoundException e) {
            throw new AbortException("Cannot create output file.", e);
        }
    }

    void writeResult(PrintStream out, DBIDs ids, OutlierResult result, ScalingFunction scaling, String label) {
        if (scaling instanceof OutlierScaling) {
            ((OutlierScaling)scaling).prepare(result);
        }
        out.append(label);
        DoubleRelation scores = result.getScores();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double value = scores.doubleValue(iter);
            value = scaling != null ? scaling.getScaled(value) : value;
            out.append(' ').append(Double.toString(value));
            iter.advance();
        }
        out.append(FormatUtil.NEWLINE);
    }

    private void runForEachK(String prefix, int mink, int maxk, IntFunction<OutlierResult> runner, BiConsumer<String, OutlierResult> out) {
        if (this.isDisabled(prefix)) {
            LOG.verbose("Skipping (disabled): " + prefix);
            return;
        }
        LOG.verbose("Running " + prefix);
        int digits = (int)FastMath.ceil(FastMath.log10(this.krange.getMax() + 1));
        String format = "%s-%0" + digits + "d";
        this.krange.forEach(k -> {
            if (k >= mink && k <= maxk) {
                Duration time = LOG.newDuration(this.getClass().getCanonicalName() + "." + prefix + ".k" + k + ".runtime").begin();
                OutlierResult result = (OutlierResult)runner.apply(k);
                LOG.statistics(time.end());
                if (result != null) {
                    out.accept(String.format(Locale.ROOT, format, prefix, k), result);
                    result.getHierarchy().removeSubtree(result);
                }
            }
        });
    }

    protected boolean isDisabled(String name) {
        return this.disable != null && this.disable.matcher(name).matches();
    }

    public static void main(String[] args) {
        ComputeKNNOutlierScores.runCLIApplication(ComputeKNNOutlierScores.class, args);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractApplication.Parameterizer {
        public static final OptionID KRANGE_ID = new OptionID("krange", "Range of k. This accepts multiple ranges, such as 1,2,..,10,20,..,100");
        public static final OptionID SCALING_ID = new OptionID("scaling", "Scaling function.");
        public static final OptionID DISABLE_ID = new OptionID("disable", "Disable methods (regular expression, case insensitive, anchored).");
        public static final OptionID KSQUARE_ID = new OptionID("ksquaremax", "Maximum k for methods with O(k^2) cost.");
        IntGenerator krange;
        InputStep inputstep;
        DistanceFunction<? super O> distf;
        ByLabelOutlier bylabel;
        ScalingFunction scaling = null;
        File outfile;
        Pattern disable = null;
        int ksquarestop = 100;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter ksqP;
            PatternParameter disableP;
            IntGeneratorParameter kP;
            super.makeOptions(config);
            this.inputstep = config.tryInstantiate(InputStep.class);
            ObjectParameter distP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distP)) {
                this.distf = (DistanceFunction)distP.instantiateClass(config);
            }
            if (config.grab(kP = new IntGeneratorParameter(KRANGE_ID))) {
                this.krange = (IntGenerator)kP.getValue();
            }
            this.bylabel = config.tryInstantiate(ByLabelOutlier.class);
            this.outfile = super.getParameterOutputFile(config, "File to output the resulting score vectors to.");
            ObjectParameter scalingP = new ObjectParameter(SCALING_ID, ScalingFunction.class);
            scalingP.setOptional(true);
            if (config.grab(scalingP)) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
            if (config.grab(disableP = (PatternParameter)new PatternParameter(DISABLE_ID).setOptional(true))) {
                this.disable = (Pattern)disableP.getValue();
            }
            if (config.grab(ksqP = new IntParameter(KSQUARE_ID, 100))) {
                this.ksquarestop = ksqP.intValue();
            }
        }

        @Override
        protected ComputeKNNOutlierScores<O> makeInstance() {
            return new ComputeKNNOutlierScores<O>(this.inputstep, this.distf, this.krange, this.bylabel, this.outfile, this.scaling, this.disable, this.ksquarestop);
        }
    }
}

