/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.evaluation.scores.AveragePrecisionEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.DCGEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.MaximumF1Evaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.NDCGEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.PrecisionAtKEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.AbstractVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.IncreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;

public class EvaluatePrecomputedOutlierScores
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(EvaluatePrecomputedOutlierScores.class);
    public static final String KNOWN_REVERSED = "(ODIN|DWOF|gaussian-model|silhouette|OutRank|OUTRES|aggarwal.?yu|ABOD)";
    File infile;
    StreamingParser parser;
    Pattern reverse;
    File outfile;
    String name;
    VectorNonZero positive;
    double endcg;

    public EvaluatePrecomputedOutlierScores(File infile, StreamingParser parser, Pattern reverse, File outfile, String name) {
        this.infile = infile;
        this.parser = parser;
        this.reverse = reverse;
        this.outfile = outfile;
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try (FileInputStream fis = new FileInputStream(this.infile);
             BufferedInputStream is = new BufferedInputStream(FileUtil.tryGzipInput(fis));
             FileOutputStream fosResult = new FileOutputStream(this.outfile, true);
             PrintStream fout = new PrintStream(fosResult);
             FileChannel chan = fosResult.getChannel();){
            this.parser.initStream(is);
            chan.lock();
            if (chan.position() == 0L) {
                this.writeHeader(fout);
            } else {
                LOG.info("Appending to existing output " + this.outfile);
            }
            int lcol = -1;
            int dcol = -1;
            while (true) {
                BundleStreamSource.Event ev = this.parser.nextEvent();
                switch (ev) {
                    case END_OF_STREAM: {
                        return;
                    }
                    case META_CHANGED: {
                        BundleMeta meta = this.parser.getMeta();
                        lcol = -1;
                        dcol = -1;
                        for (int i = 0; i < meta.size(); ++i) {
                            SimpleTypeInformation m = (SimpleTypeInformation)meta.get(i);
                            if (TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType(m)) {
                                if (dcol >= 0) {
                                    throw new AbortException("More than one vector column.");
                                }
                                dcol = i;
                                continue;
                            }
                            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType(m)) throw new AbortException("Unexpected data column type: " + m);
                            if (lcol >= 0) {
                                throw new AbortException("More than one label column.");
                            }
                            lcol = i;
                        }
                        break;
                    }
                    case NEXT_OBJECT: {
                        if (lcol < 0) {
                            throw new AbortException("No label column available.");
                        }
                        if (dcol < 0) {
                            throw new AbortException("No vector column available.");
                        }
                        this.processRow(fout, (NumberVector)this.parser.data(dcol), this.parser.data(lcol).toString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AbortException("IO error.", e);
        }
    }

    private void writeHeader(PrintStream fout) {
        if (this.name != null) {
            fout.append("\"Name\",");
        }
        fout.append("\"Algorithm\",\"k\"").append(",\"ROC AUC\"").append(",\"Average Precision\"").append(",\"R-Precision\"").append(",\"Maximum F1\"").append(",\"DCG\"").append(",\"NDCG\"").append(",\"Adjusted ROC AUC\"").append(",\"Adjusted Average Precision\"").append(",\"Adjusted R-Precision\"").append(",\"Adjusted Maximum F1\"").append(",\"Adjusted DCG\"").append('\n');
    }

    private void processRow(PrintStream fout, NumberVector vec, String label) {
        if (this.checkForNaNs(vec)) {
            LOG.warning("NaN value encountered in vector " + label);
            return;
        }
        if (this.positive == null) {
            if (!label.matches("bylabel")) {
                throw new AbortException("No 'by label' reference outlier found, which is needed for evaluation!");
            }
            this.positive = new VectorNonZero(vec);
            this.endcg = NDCGEvaluation.STATIC.expected(this.positive.numPositive(), this.positive.getDimensionality());
            return;
        }
        AbstractVectorIter iter = this.reverse.matcher(label).find() ? new IncreasingVectorIter(vec) : new DecreasingVectorIter(vec);
        double expected = (double)this.positive.numPositive() / (double)this.positive.getDimensionality();
        double auc = ROCEvaluation.STATIC.evaluate(this.positive, iter.seek(0));
        double avep = AveragePrecisionEvaluation.STATIC.evaluate(this.positive, iter.seek(0));
        double rprecision = PrecisionAtKEvaluation.RPRECISION.evaluate(this.positive, iter.seek(0));
        double maxf1 = MaximumF1Evaluation.STATIC.evaluate(this.positive, iter.seek(0));
        double dcg = DCGEvaluation.STATIC.evaluate(this.positive, iter.seek(0));
        double ndcg = NDCGEvaluation.STATIC.evaluate(this.positive, iter.seek(0));
        double adjauc = 2.0 * auc - 1.0;
        double adjrprecision = (rprecision - expected) / (1.0 - expected);
        double adjavep = (avep - expected) / (1.0 - expected);
        double adjmaxf1 = (maxf1 - expected) / (1.0 - expected);
        double adjdcg = (ndcg - this.endcg) / (1.0 - this.endcg);
        int p = label.lastIndexOf(45);
        String prefix = label.substring(0, p);
        int k = Integer.valueOf(label.substring(p + 1));
        if (this.name != null) {
            fout.append('\"').append(this.name).append("\",");
        }
        fout.append('\"').append(prefix).append('\"').append(',').append(Integer.toString(k)).append(',').append(Double.toString(auc)).append(',').append(Double.toString(avep)).append(',').append(Double.toString(rprecision)).append(',').append(Double.toString(maxf1)).append(',').append(Double.toString(dcg)).append(',').append(Double.toString(ndcg)).append(',').append(Double.toString(adjauc)).append(',').append(Double.toString(adjavep)).append(',').append(Double.toString(adjrprecision)).append(',').append(Double.toString(adjmaxf1)).append(',').append(Double.toString(adjdcg)).append('\n');
    }

    private boolean checkForNaNs(NumberVector vec) {
        int d = vec.getDimensionality();
        for (int i = 0; i < d; ++i) {
            double v = vec.doubleValue(i);
            if (v == v) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        EvaluatePrecomputedOutlierScores.runCLIApplication(EvaluatePrecomputedOutlierScores.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID NAME_ID = new OptionID("name", "Data set name to use in a 'Name' CSV column.");
        public static final OptionID PARSER_ID = new OptionID("parser", "Input parser.");
        public static final OptionID REVERSED_ID = new OptionID("reversed", "Pattern to recognize reversed methods.");
        File infile;
        StreamingParser parser;
        Pattern reverse;
        File outfile;
        String name;

        @Override
        protected void makeOptions(Parameterization config) {
            PatternParameter reverseP;
            super.makeOptions(config);
            this.infile = super.getParameterInputFile(config, "Input file containing the outlier score vectors.");
            ObjectParameter parserP = new ObjectParameter(PARSER_ID, (Class<?>)StreamingParser.class, NumberVectorLabelParser.class);
            if (config.grab(parserP)) {
                this.parser = (StreamingParser)parserP.instantiateClass(config);
            }
            this.outfile = super.getParameterOutputFile(config, "File to output the resulting evaluation vectors to.");
            StringParameter nameP = (StringParameter)new StringParameter(NAME_ID).setOptional(true);
            if (config.grab(nameP)) {
                this.name = (String)nameP.getValue();
            }
            if (config.grab(reverseP = new PatternParameter(REVERSED_ID, EvaluatePrecomputedOutlierScores.KNOWN_REVERSED))) {
                this.reverse = (Pattern)reverseP.getValue();
            }
        }

        @Override
        protected EvaluatePrecomputedOutlierScores makeInstance() {
            return new EvaluatePrecomputedOutlierScores(this.infile, this.parser, this.reverse, this.outfile, this.name);
        }
    }
}

