/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.correlation.WeightedPearsonCorrelationDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.WeightedSquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVotingMean;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.util.ArrayList;
import java.util.Arrays;

@Reference(authors="Erich Schubert, Remigius Wojdanowski, Arthur Zimek, Hans-Peter Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM Int. Conf. on Data Mining (SDM 2012)", url="https://doi.org/10.1137/1.9781611972825.90", bibkey="DBLP:conf/sdm/SchubertWZK12")
public class GreedyEnsembleExperiment
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(GreedyEnsembleExperiment.class);
    private InputStep inputstep;
    boolean refine_truth = false;
    EnsembleVoting voting;
    ScalingFunction prescaling;
    ScalingFunction scaling;
    double rate;
    int minvote = 1;
    Distance distance = Distance.PEARSON;

    public GreedyEnsembleExperiment(InputStep inputstep, EnsembleVoting voting, Distance distance, ScalingFunction prescaling, ScalingFunction scaling, double rate) {
        this.inputstep = inputstep;
        this.voting = voting;
        this.distance = distance;
        this.prescaling = prescaling;
        this.scaling = scaling;
        this.rate = rate;
    }

    @Override
    public void run() {
        PrimitiveDistanceFunction<NumberVector> wdist;
        DBID firstid;
        Database database = this.inputstep.getDatabase();
        Relation<NumberVector> relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<String> labels = DatabaseUtil.guessLabelRepresentation(database);
        String firstlabel = labels.get(firstid = DBIDUtil.deref(labels.iterDBIDs()));
        if (!firstlabel.matches("bylabel")) {
            throw new AbortException("No 'by label' reference outlier found, which is needed for weighting!");
        }
        relation = GreedyEnsembleExperiment.applyPrescaling(this.prescaling, relation, firstid);
        int numcand = relation.size() - 1;
        int dim = RelationUtil.dimensionality(relation);
        NumberVector refvec = relation.get(firstid);
        VectorNonZero positive = new VectorNonZero(refvec);
        int desired_outliers = (int)(this.rate * (double)dim);
        int union_outliers = 0;
        int[] outliers_seen = new int[dim];
        int k = 0;
        ArrayList<DecreasingVectorIter> iters = new ArrayList<DecreasingVectorIter>(numcand);
        if (this.minvote >= numcand) {
            this.minvote = Math.max(1, numcand - 1);
        }
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            if (!DBIDUtil.equal(firstid, iditer)) {
                iters.add(new DecreasingVectorIter(relation.get(iditer)));
            }
            iditer.advance();
        }
        block1: while (union_outliers < desired_outliers) {
            for (DecreasingVectorIter iter : iters) {
                int cur;
                if (!iter.valid()) {
                    LOG.warning("Union_outliers=" + union_outliers + " < desired_outliers=" + desired_outliers + " minvote=" + this.minvote);
                    break block1;
                }
                int n = cur = iter.dim();
                outliers_seen[n] = outliers_seen[n] + 1;
                if (outliers_seen[cur] == this.minvote) {
                    ++union_outliers;
                }
                iter.advance();
            }
            ++k;
        }
        LOG.verbose("Merged top " + k + " outliers to: " + union_outliers + " outliers (desired: at least " + desired_outliers + ")");
        double[] estimated_weights = new double[dim];
        double[] estimated_truth = new double[dim];
        this.updateEstimations(outliers_seen, union_outliers, estimated_weights, estimated_truth);
        DoubleVector estimated_truth_vec = DoubleVector.wrap(estimated_truth);
        PrimitiveDistanceFunction<NumberVector> tdist = wdist = this.getDistanceFunction(estimated_weights);
        double[] naiveensemble = new double[dim];
        double[] buf = new double[numcand];
        for (int d = 0; d < dim; ++d) {
            int i = 0;
            DBIDIter iditer2 = relation.iterDBIDs();
            while (iditer2.valid()) {
                if (!DBIDUtil.equal(firstid, iditer2)) {
                    NumberVector vec = relation.get(iditer2);
                    buf[i] = vec.doubleValue(d);
                    ++i;
                }
                iditer2.advance();
            }
            naiveensemble[d] = this.voting.combine(buf, i);
            if (!Double.isNaN(naiveensemble[d])) continue;
            LOG.warning("NaN after combining: " + FormatUtil.format(buf) + " i=" + i + " " + this.voting.toString());
        }
        DoubleVector naivevec = DoubleVector.wrap(naiveensemble);
        double bestauc = 0.0;
        String bestaucstr = "";
        double bestcost = Double.POSITIVE_INFINITY;
        String bestcoststr = "";
        DBID bestid = null;
        double bestest = Double.POSITIVE_INFINITY;
        double[] greedyensemble = new double[dim];
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            if (!DBIDUtil.equal(firstid, iditer3)) {
                NumberVector vec = relation.get(iditer3);
                this.singleEnsemble(greedyensemble, vec);
                double auc = ROCEvaluation.computeROCAUC(positive, new DecreasingVectorIter(DoubleVector.wrap(greedyensemble)));
                double estimated = wdist.distance(DoubleVector.wrap(greedyensemble), estimated_truth_vec);
                double cost = tdist.distance(DoubleVector.wrap(greedyensemble), refvec);
                LOG.verbose("ROC AUC: " + auc + " estimated " + estimated + " cost " + cost + " " + labels.get(iditer3));
                if (auc > bestauc) {
                    bestauc = auc;
                    bestaucstr = labels.get(iditer3);
                }
                if (cost < bestcost) {
                    bestcost = cost;
                    bestcoststr = labels.get(iditer3);
                }
                if (estimated < bestest || bestid == null) {
                    bestest = estimated;
                    bestid = DBIDUtil.deref(iditer3);
                }
            }
            iditer3.advance();
        }
        if (this.prescaling != null) {
            LOG.verbose("Input prescaling: " + this.prescaling);
        }
        LOG.verbose("Distance function: " + wdist);
        LOG.verbose("Ensemble voting: " + this.voting);
        if (this.scaling != null) {
            LOG.verbose("Ensemble rescaling: " + this.scaling);
        }
        LOG.verbose("Initial estimation of outliers: " + union_outliers);
        LOG.verbose("Initializing ensemble with: " + labels.get(bestid));
        ArrayModifiableDBIDs ensemble = DBIDUtil.newArray(bestid);
        HashSetModifiableDBIDs enscands = DBIDUtil.newHashSet(relation.getDBIDs());
        HashSetModifiableDBIDs dropped = DBIDUtil.newHashSet(relation.size());
        dropped.add(firstid);
        enscands.remove(bestid);
        enscands.remove(firstid);
        double[] greedyensemble2 = new double[dim];
        this.singleEnsemble(greedyensemble2, relation.get(bestid));
        double[] testensemble = new double[dim];
        block6: while (enscands.size() > 0) {
            NumberVector vec;
            DoubleVector greedyvec = DoubleVector.wrap(greedyensemble2);
            double oldd = wdist.distance(estimated_truth_vec, greedyvec);
            int heapsize = enscands.size();
            ModifiableDoubleDBIDList heap = DBIDUtil.newDistanceDBIDList(heapsize);
            double[] tmp = new double[dim];
            DBIDMIter iter = enscands.iter();
            while (iter.valid()) {
                vec = relation.get(iter);
                this.singleEnsemble(tmp, vec);
                double diversity = wdist.distance(DoubleVector.wrap(greedyensemble2), greedyvec);
                heap.add(diversity, iter);
                iter.advance();
            }
            heap.sort();
            DoubleDBIDListMIter it = heap.iter();
            while (heap.size() > 0) {
                it.seek(heap.size() - 1);
                enscands.remove(it);
                vec = relation.get(it);
                double[] buf2 = new double[ensemble.size() + 1];
                for (int i = 0; i < dim; ++i) {
                    int j = 0;
                    DBIDMIter iter2 = ensemble.iter();
                    while (iter2.valid()) {
                        buf2[j] = relation.get(iter2).doubleValue(i);
                        ++j;
                        iter2.advance();
                    }
                    buf2[j] = vec.doubleValue(i);
                    testensemble[i] = this.voting.combine(buf2, j + 1);
                }
                GreedyEnsembleExperiment.applyScaling(testensemble, this.scaling);
                DoubleVector testvec = DoubleVector.wrap(testensemble);
                double newd = wdist.distance(estimated_truth_vec, testvec);
                if (newd < oldd) {
                    System.arraycopy(testensemble, 0, greedyensemble2, 0, dim);
                    ensemble.add(it);
                    continue block6;
                }
                dropped.add(it);
                if (this.refine_truth) {
                    ArrayList<DecreasingVectorIter> iters2 = new ArrayList<DecreasingVectorIter>(numcand);
                    Object iditer4 = relation.iterDBIDs();
                    while (iditer4.valid()) {
                        if (!DBIDUtil.equal(firstid, (DBIDRef)iditer4) && !dropped.contains((DBIDRef)iditer4)) {
                            iters2.add(new DecreasingVectorIter(relation.get((DBIDRef)iditer4)));
                        }
                        iditer4.advance();
                    }
                    if (this.minvote >= iters2.size()) {
                        this.minvote = iters2.size() - 1;
                    }
                    union_outliers = 0;
                    Arrays.fill(outliers_seen, 0);
                    while (union_outliers < desired_outliers) {
                        DecreasingVectorIter iter3;
                        iditer4 = iters2.iterator();
                        while (iditer4.hasNext() && (iter3 = (DecreasingVectorIter)iditer4.next()).valid()) {
                            int cur = iter3.dim();
                            if (outliers_seen[cur] == 0) {
                                outliers_seen[cur] = 1;
                            } else {
                                int n = cur;
                                outliers_seen[n] = outliers_seen[n] + 1;
                            }
                            if (outliers_seen[cur] == this.minvote) {
                                ++union_outliers;
                            }
                            iter3.advance();
                        }
                    }
                    LOG.warning("New num outliers: " + union_outliers);
                    this.updateEstimations(outliers_seen, union_outliers, estimated_weights, estimated_truth);
                    estimated_truth_vec = DoubleVector.wrap(estimated_truth);
                }
                it.remove();
            }
        }
        StringBuilder greedylbl = new StringBuilder();
        DBIDMIter iter = ensemble.iter();
        while (iter.valid()) {
            if (greedylbl.length() > 0) {
                greedylbl.append(' ');
            }
            greedylbl.append(labels.get(iter));
            iter.advance();
        }
        DoubleVector greedyvec = DoubleVector.wrap(greedyensemble2);
        if (this.refine_truth) {
            LOG.verbose("Estimated outliers remaining: " + union_outliers);
        }
        LOG.verbose("Greedy ensemble (" + ensemble.size() + "): " + greedylbl.toString());
        LOG.verbose("Best single ROC AUC: " + bestauc + " (" + bestaucstr + ")");
        LOG.verbose("Best single cost:    " + bestcost + " (" + bestcoststr + ")");
        double naiveauc = ROCEvaluation.computeROCAUC(positive, new DecreasingVectorIter(naivevec));
        double naivecost = tdist.distance(naivevec, refvec);
        LOG.verbose("Naive ensemble AUC:   " + naiveauc + " cost: " + naivecost);
        LOG.verbose("Naive ensemble Gain:  " + this.gain(naiveauc, bestauc, 1.0) + " cost gain: " + this.gain(naivecost, bestcost, 0.0));
        double greedyauc = ROCEvaluation.computeROCAUC(positive, new DecreasingVectorIter(greedyvec));
        double greedycost = tdist.distance(greedyvec, refvec);
        LOG.verbose("Greedy ensemble AUC:  " + greedyauc + " cost: " + greedycost);
        LOG.verbose("Greedy ensemble Gain to best:  " + this.gain(greedyauc, bestauc, 1.0) + " cost gain: " + this.gain(greedycost, bestcost, 0.0));
        LOG.verbose("Greedy ensemble Gain to naive: " + this.gain(greedyauc, naiveauc, 1.0) + " cost gain: " + this.gain(greedycost, naivecost, 0.0));
        MeanVariance meanauc = new MeanVariance();
        MeanVariance meancost = new MeanVariance();
        HashSetModifiableDBIDs candidates = DBIDUtil.newHashSet(relation.getDBIDs());
        candidates.remove(firstid);
        for (int i = 0; i < 1000; ++i) {
            double[] randomensemble = new double[dim];
            ModifiableDBIDs random = DBIDUtil.randomSample((DBIDs)candidates, ensemble.size(), Long.valueOf(i));
            double[] buf3 = new double[random.size()];
            for (int d = 0; d < dim; ++d) {
                int j = 0;
                DBIDIter iter4 = random.iter();
                while (iter4.valid()) {
                    assert (!DBIDUtil.equal(firstid, iter4));
                    NumberVector vec = relation.get(iter4);
                    buf3[j] = vec.doubleValue(d);
                    ++j;
                    iter4.advance();
                }
                randomensemble[d] = this.voting.combine(buf3, j);
            }
            GreedyEnsembleExperiment.applyScaling(randomensemble, this.scaling);
            DoubleVector randomvec = DoubleVector.wrap(randomensemble);
            double auc = ROCEvaluation.computeROCAUC(positive, new DecreasingVectorIter(randomvec));
            meanauc.put(auc);
            double cost = tdist.distance(randomvec, refvec);
            meancost.put(cost);
        }
        LOG.verbose("Random ensemble AUC:  " + meanauc.getMean() + " + stddev: " + meanauc.getSampleStddev() + " = " + (meanauc.getMean() + meanauc.getSampleStddev()));
        LOG.verbose("Random ensemble Gain: " + this.gain(meanauc.getMean(), bestauc, 1.0));
        LOG.verbose("Greedy improvement:   " + (greedyauc - meanauc.getMean()) / meanauc.getSampleStddev() + " standard deviations.");
        LOG.verbose("Random ensemble Cost: " + meancost.getMean() + " + stddev: " + meancost.getSampleStddev() + " = " + (meancost.getMean() + meanauc.getSampleStddev()));
        LOG.verbose("Random ensemble Gain: " + this.gain(meancost.getMean(), bestcost, 0.0));
        LOG.verbose("Greedy improvement:   " + (meancost.getMean() - greedycost) / meancost.getSampleStddev() + " standard deviations.");
        LOG.verbose("Naive ensemble Gain to random: " + this.gain(naiveauc, meanauc.getMean(), 1.0) + " cost gain: " + this.gain(naivecost, meancost.getMean(), 0.0));
        LOG.verbose("Random ensemble Gain to naive: " + this.gain(meanauc.getMean(), naiveauc, 1.0) + " cost gain: " + this.gain(meancost.getMean(), naivecost, 0.0));
        LOG.verbose("Greedy ensemble Gain to random: " + this.gain(greedyauc, meanauc.getMean(), 1.0) + " cost gain: " + this.gain(greedycost, meancost.getMean(), 0.0));
    }

    protected void singleEnsemble(double[] ensemble, NumberVector vec) {
        double[] buf = new double[1];
        for (int i = 0; i < ensemble.length; ++i) {
            buf[0] = vec.doubleValue(i);
            ensemble[i] = this.voting.combine(buf, 1);
            if (!Double.isNaN(ensemble[i])) continue;
            LOG.warning("NaN after combining: " + FormatUtil.format(buf) + " " + this.voting.toString());
        }
        GreedyEnsembleExperiment.applyScaling(ensemble, this.scaling);
    }

    public static Relation<NumberVector> applyPrescaling(ScalingFunction scaling, Relation<NumberVector> relation, DBIDs skip) {
        if (scaling == null) {
            return relation;
        }
        NumberVector.Factory<NumberVector> factory = RelationUtil.getNumberVectorFactory(relation);
        DBIDs ids = relation.getDBIDs();
        WritableDataStore<NumberVector> contents = DataStoreUtil.makeStorage(ids, 2, NumberVector.class);
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            NumberVector v = relation.get(iter);
            double[] raw = v.toArray();
            if (!skip.contains(iter)) {
                GreedyEnsembleExperiment.applyScaling(raw, scaling);
            }
            contents.put(iter, factory.newNumberVector(raw, ArrayLikeUtil.DOUBLEARRAYADAPTER));
            iter.advance();
        }
        return new MaterializedRelation<NumberVector>(relation.getDataTypeInformation(), ids, "rescaled", contents);
    }

    private static void applyScaling(double[] raw, ScalingFunction scaling) {
        if (scaling == null) {
            return;
        }
        if (scaling instanceof OutlierScaling) {
            ((OutlierScaling)scaling).prepare(raw, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        }
        for (int i = 0; i < raw.length; ++i) {
            double newval = scaling.getScaled(raw[i]);
            if (Double.isNaN(newval)) {
                LOG.warning("NaN after prescaling: " + raw[i] + " " + scaling.toString() + " -> " + newval);
            }
            raw[i] = newval;
        }
    }

    protected void updateEstimations(int[] outliers, int numoutliers, double[] weights, double[] truth) {
        double oweight = 0.5 / (double)numoutliers;
        double iweight = 0.5 / (double)(outliers.length - numoutliers);
        double oscore = 1.0;
        double iscore = 0.0;
        for (int i = 0; i < outliers.length; ++i) {
            if (outliers[i] >= this.minvote) {
                weights[i] = oweight;
                truth[i] = 1.0;
                continue;
            }
            weights[i] = iweight;
            truth[i] = 0.0;
        }
    }

    private PrimitiveDistanceFunction<NumberVector> getDistanceFunction(double[] estimated_weights) {
        switch (this.distance) {
            case SQEUCLIDEAN: {
                return new WeightedSquaredEuclideanDistanceFunction(estimated_weights);
            }
            case EUCLIDEAN: {
                return new WeightedEuclideanDistanceFunction(estimated_weights);
            }
            case MANHATTAN: {
                return new WeightedManhattanDistanceFunction(estimated_weights);
            }
            case PEARSON: {
                return new WeightedPearsonCorrelationDistanceFunction(estimated_weights);
            }
        }
        throw new AbortException("Unsupported distance mode: " + (Object)((Object)this.distance));
    }

    double gain(double score, double ref, double optimal) {
        return 1.0 - (optimal - score) / (optimal - ref);
    }

    public static void main(String[] args) {
        GreedyEnsembleExperiment.runCLIApplication(GreedyEnsembleExperiment.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("greedy.rate", "Expected rate of outliers.");
        public static final OptionID VOTING_ID = new OptionID("ensemble.voting", "Ensemble voting function.");
        public static final OptionID PRESCALING_ID = new OptionID("ensemble.prescaling", "Prescaling to apply to input scores.");
        public static final OptionID SCALING_ID = new OptionID("ensemble.scaling", "Scaling to apply to ensemble.");
        public static final OptionID DISTANCE_ID = new OptionID("ensemble.measure", "Similarity measure.");
        InputStep inputstep;
        EnsembleVoting voting;
        Distance distance = Distance.PEARSON;
        ScalingFunction prescaling;
        ScalingFunction scaling;
        double rate = 0.01;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter rateP;
            EnumParameter<Distance> distanceP;
            super.makeOptions(config);
            this.inputstep = config.tryInstantiate(InputStep.class);
            ObjectParameter votingP = new ObjectParameter(VOTING_ID, (Class<?>)EnsembleVoting.class, EnsembleVotingMean.class);
            if (config.grab(votingP)) {
                this.voting = (EnsembleVoting)votingP.instantiateClass(config);
            }
            if (config.grab(distanceP = new EnumParameter<Distance>(DISTANCE_ID, Distance.class))) {
                this.distance = (Distance)((Object)distanceP.getValue());
            }
            ObjectParameter prescalingP = new ObjectParameter(PRESCALING_ID, ScalingFunction.class);
            prescalingP.setOptional(true);
            if (config.grab(prescalingP)) {
                this.prescaling = (ScalingFunction)prescalingP.instantiateClass(config);
            }
            ObjectParameter scalingP = new ObjectParameter(SCALING_ID, ScalingFunction.class);
            scalingP.setOptional(true);
            if (config.grab(scalingP)) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
            if (config.grab(rateP = new DoubleParameter(RATE_ID, 0.01))) {
                this.rate = rateP.doubleValue();
            }
        }

        @Override
        protected GreedyEnsembleExperiment makeInstance() {
            return new GreedyEnsembleExperiment(this.inputstep, this.voting, this.distance, this.prescaling, this.scaling, this.rate);
        }
    }

    public static enum Distance {
        PEARSON,
        SQEUCLIDEAN,
        EUCLIDEAN,
        MANHATTAN;

    }
}

