/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.application.greedyensemble.GreedyEnsembleExperiment;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.DecreasingVectorIter;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.VectorNonZero;
import de.lmu.ifi.dbs.elki.evaluation.similaritymatrix.ComputeSimilarityMatrixImage;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVotingMean;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.SimpleSVGViewer;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.SimilarityMatrixVisualizer;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.awt.image.BufferedImage;

@Reference(authors="Erich Schubert, Remigius Wojdanowski, Arthur Zimek, Hans-Peter Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM Int. Conf. on Data Mining (SDM 2012)", url="https://doi.org/10.1137/1.9781611972825.90", bibkey="DBLP:conf/sdm/SchubertWZK12")
public class VisualizePairwiseGainMatrix
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(VisualizePairwiseGainMatrix.class);
    private InputStep inputstep;
    private VisualizerParameterizer vispar;
    private ScalingFunction prescaling;
    private EnsembleVoting voting;

    public VisualizePairwiseGainMatrix(InputStep inputstep, ScalingFunction prescaling, EnsembleVoting voting, VisualizerParameterizer vispar) {
        this.inputstep = inputstep;
        this.prescaling = prescaling;
        this.voting = voting;
        this.vispar = vispar;
    }

    @Override
    public void run() {
        int a;
        DBID firstid;
        Database database = this.inputstep.getDatabase();
        ResultHierarchy hier = database.getHierarchy();
        Relation<NumberVector> relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        Relation<String> labels = DatabaseUtil.guessLabelRepresentation(database);
        String firstlabel = labels.get(firstid = DBIDUtil.deref(labels.iterDBIDs()));
        if (!firstlabel.matches(".*by.?label.*")) {
            throw new AbortException("No 'by label' reference outlier found, which is needed for weighting!");
        }
        relation = GreedyEnsembleExperiment.applyPrescaling(this.prescaling, relation, firstid);
        int dim = RelationUtil.dimensionality(relation);
        NumberVector refvec = relation.get(firstid);
        VectorNonZero pos = new VectorNonZero(refvec);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(relation.getDBIDs());
        ids.remove(firstid);
        ids.sort();
        int size = ids.size();
        double[][] data = new double[size][size];
        DoubleMinMax minmax = new DoubleMinMax();
        DoubleMinMax commax = new DoubleMinMax();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing ensemble gain.", size * (size + 1) >> 1, LOG) : null;
        double[] buf = new double[2];
        int a2 = 0;
        DBIDArrayMIter id = ids.iter();
        while (id.valid()) {
            double auc;
            NumberVector veca = relation.get(id);
            data[a2][a2] = auc = ROCEvaluation.computeROCAUC(pos, new DecreasingVectorIter(veca));
            LOG.incrementProcessed(prog);
            DBIDArrayMIter id2 = ids.iter();
            id2.seek(a2 + 1);
            for (int b = a2 + 1; b < size; ++b) {
                double auc2;
                NumberVector vecb = relation.get(id2);
                double[] combined = new double[dim];
                for (int d = 0; d < dim; ++d) {
                    buf[0] = veca.doubleValue(d);
                    buf[1] = vecb.doubleValue(d);
                    combined[d] = this.voting.combine(buf);
                }
                data[a2][b] = auc2 = ROCEvaluation.computeROCAUC(pos, new DecreasingVectorIter(DoubleVector.wrap(combined)));
                data[b][a2] = auc2;
                commax.put(data[a2][b]);
                LOG.incrementProcessed(prog);
                id2.advance();
            }
            id.advance();
            ++a2;
        }
        LOG.ensureCompleted(prog);
        for (a = 0; a < size; ++a) {
            for (int b = a + 1; b < size; ++b) {
                double ref = Math.max(data[a][a], data[b][b]);
                data[a][b] = (data[a][b] - ref) / (1.0 - ref);
                data[b][a] = (data[b][a] - ref) / (1.0 - ref);
                minmax.put(data[a][b]);
            }
        }
        for (a = 0; a < size; ++a) {
            data[a][a] = 0.0;
        }
        LOG.verbose("Gain: " + minmax.toString() + " AUC: " + commax.toString());
        boolean hasneg = minmax.getMin() < -0.001;
        LinearScaling scale = !hasneg ? LinearScaling.fromMinMax(0.0, minmax.getMax()) : LinearScaling.fromMinMax(0.0, Math.max(minmax.getMax(), -minmax.getMin()));
        scale = LinearScaling.fromMinMax(0.0, 0.5);
        BufferedImage img = new BufferedImage(size, size, 1);
        for (int x = 0; x < size; ++x) {
            for (int y = x; y < size; ++y) {
                int col;
                int ival;
                double val = data[x][y];
                if ((val = Math.max(-1.0, Math.min(1.0, scale.getScaled(val)))) >= 0.0) {
                    ival = 0xFF & (int)(255.0 * val);
                    col = 0xFF000000 | ival << 8;
                } else {
                    ival = 0xFF & (int)(255.0 * -val);
                    col = 0xFF000000 | ival << 16;
                }
                img.setRGB(x, y, col);
                img.setRGB(y, x, col);
            }
        }
        ComputeSimilarityMatrixImage.SimilarityMatrix smat = new ComputeSimilarityMatrixImage.SimilarityMatrix(img, relation, ids);
        hier.add(database, smat);
        VisualizerContext context = this.vispar.newContext(hier, smat);
        SimilarityMatrixVisualizer factory = new SimilarityMatrixVisualizer();
        factory.processNewResult(context, database);
        VisualizationTree.findVis(context).filter(VisualizationTask.class).forEach(task -> {
            if (task.getFactory() == factory) {
                this.showVisualization(context, factory, (VisualizationTask)task);
            }
        });
    }

    private void showVisualization(VisualizerContext context, SimilarityMatrixVisualizer factory, VisualizationTask task) {
        VisualizationPlot plot = new VisualizationPlot();
        Visualization vis = factory.makeVisualization(context, task, plot, 1.0, 1.0, null);
        plot.getRoot().appendChild(vis.getLayer());
        plot.getRoot().setAttribute("width", "20cm");
        plot.getRoot().setAttribute("height", "20cm");
        plot.getRoot().setAttribute("viewBox", "0 0 1 1");
        plot.updateStyleElement();
        new SimpleSVGViewer().setPlot(plot);
    }

    public static void main(String[] args) {
        VisualizePairwiseGainMatrix.runCLIApplication(VisualizePairwiseGainMatrix.class, args);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        private InputStep inputstep;
        private VisualizerParameterizer vispar;
        private ScalingFunction prescaling;
        private EnsembleVoting voting;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter votingP;
            super.makeOptions(config);
            this.inputstep = config.tryInstantiate(InputStep.class);
            this.vispar = config.tryInstantiate(VisualizerParameterizer.class);
            ObjectParameter prescalingP = new ObjectParameter(GreedyEnsembleExperiment.Parameterizer.PRESCALING_ID, ScalingFunction.class);
            prescalingP.setOptional(true);
            if (config.grab(prescalingP)) {
                this.prescaling = (ScalingFunction)prescalingP.instantiateClass(config);
            }
            if (config.grab(votingP = new ObjectParameter(GreedyEnsembleExperiment.Parameterizer.VOTING_ID, (Class<?>)EnsembleVoting.class, EnsembleVotingMean.class))) {
                this.voting = (EnsembleVoting)votingP.instantiateClass(config);
            }
        }

        @Override
        protected VisualizePairwiseGainMatrix makeInstance() {
            return new VisualizePairwiseGainMatrix(this.inputstep, this.prescaling, this.voting, this.vispar);
        }
    }
}

