/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceLoader;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckELKIServices {
    private static final Logging LOG = Logging.getLogger(CheckELKIServices.class);
    private Pattern strip = Pattern.compile("^[\\s#]*(?:deprecated:\\s*)?(.*?)[\\s]*$");

    public static void main(String[] argv) {
        String update = null;
        if (argv.length == 2 && "-update".equals(argv[0])) {
            update = argv[1];
            LOG.info("Updating service files in folder: " + update);
        } else if (argv.length != 0) {
            throw new AbortException("Incorrect command line parameters.");
        }
        new CheckELKIServices().checkServices(update);
    }

    public void checkServices(String update) {
        Enumeration<URL> us;
        TreeSet<String> props = new TreeSet<String>();
        try {
            us = this.getClass().getClassLoader().getResources("META-INF/elki/");
        }
        catch (IOException e) {
            throw new AbortException("Error enumerating service folders.", e);
        }
        while (us.hasMoreElements()) {
            URL u = us.nextElement();
            try {
                if ("jar".equals(u.getProtocol())) {
                    JarURLConnection con = (JarURLConnection)u.openConnection();
                    JarFile jar = con.getJarFile();
                    Throwable throwable = null;
                    try {
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            String prop = entries.nextElement().getName();
                            if (prop.startsWith("META-INF/elki/")) {
                                props.add(prop.substring("META-INF/elki/".length()));
                                continue;
                            }
                            if (!prop.startsWith(ELKIServiceLoader.FILENAME_PREFIX)) continue;
                            props.add(prop.substring(ELKIServiceLoader.FILENAME_PREFIX.length()));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jar == null) continue;
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jar.close();
                        continue;
                    }
                }
                if (!"file".equals(u.getProtocol())) continue;
                props.addAll(Arrays.asList(new File(u.toURI()).list()));
            }
            catch (IOException | URISyntaxException e) {
                throw new AbortException("Error enumerating service folders.", e);
            }
        }
        for (String prop : props) {
            if (LOG.isVerbose()) {
                LOG.verbose("Checking property: " + prop);
            }
            this.checkService(prop, update);
        }
    }

    private void checkService(String prop, String update) {
        Class<?> cls;
        try {
            cls = Class.forName(prop);
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Service file name is not a class name: " + prop);
            return;
        }
        List<Class<?>> impls = ELKIServiceRegistry.findAllImplementations(cls, false, false);
        HashSet<String> names = new HashSet<String>();
        for (Class<?> c2 : impls) {
            names.add(c2.getName());
        }
        Matcher m = this.strip.matcher("");
        try {
            Enumeration<URL> us = this.getClass().getClassLoader().getResources("META-INF/elki/" + cls.getName());
            while (us.hasMoreElements()) {
                URL u = us.nextElement();
                boolean injar = "jar".equals(u.getProtocol());
                BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        m.reset(line);
                        if (!m.matches()) {
                            LOG.warning("Line: " + line + " didn't match regexp.");
                            continue;
                        }
                        String stripped = m.group(1);
                        if (stripped.length() <= 0) continue;
                        String[] parts = stripped.split(" ");
                        if (!names.remove(parts[0]) && !injar) {
                            LOG.warning("Name " + parts[0] + " found for property " + prop + " but no class discovered (or listed twice).");
                        }
                        this.checkAliases(cls, parts[0], parts);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
        }
        catch (IOException e) {
            LOG.exception(e);
        }
        if (!names.isEmpty()) {
            ArrayList sorted = new ArrayList(names);
            Collections.sort(sorted);
            if (update == null) {
                StringBuilder message = new StringBuilder().append("Class ").append(prop).append(" lacks suggestions:").append(FormatUtil.NEWLINE);
                for (String remaining : sorted) {
                    message.append("# ").append(remaining).append(FormatUtil.NEWLINE);
                }
                LOG.warning(message.toString());
                return;
            }
            try {
                Files.createDirectories(Paths.get(update + File.separator + ELKIServiceLoader.FILENAME_PREFIX, new String[0]), new FileAttribute[0]);
                String fname = update + File.separator + ELKIServiceLoader.FILENAME_PREFIX + prop;
                PrintStream pr = new PrintStream(new FileOutputStream(fname, true));
                pr.println();
                pr.println("### Automatically appended entries:");
                for (String remaining : sorted) {
                    pr.println(remaining);
                }
                pr.close();
                LOG.warning("Updated service file: " + fname);
            }
            catch (IOException e) {
                LOG.exception(e);
            }
        }
    }

    private void checkAliases(Class<?> parent, String classname, String[] parts) {
        Class<?> c = ELKIServiceRegistry.findImplementation(parent, classname);
        if (c == null) {
            return;
        }
        Alias ann = c.getAnnotation(Alias.class);
        if (ann == null) {
            if (parts.length > 1) {
                StringBuilder buf = new StringBuilder().append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" has the following extraneous aliases:");
                for (int i = 1; i < parts.length; ++i) {
                    buf.append(' ').append(parts[i]);
                }
                LOG.warning(buf);
            }
            return;
        }
        HashSet<String> aliases = new HashSet<String>();
        for (int i = 1; i < parts.length; ++i) {
            aliases.add(parts[i]);
        }
        StringBuilder buf = null;
        for (String a : ann.value()) {
            if (aliases.remove(a)) continue;
            if (buf == null) {
                buf = new StringBuilder().append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" is missing the following aliases:");
            }
            buf.append(' ').append(a);
        }
        if (!aliases.isEmpty()) {
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(FormatUtil.NEWLINE);
            }
            buf.append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" has the following extraneous aliases:");
            for (String a : aliases) {
                buf.append(' ').append(a);
            }
        }
        if (buf != null) {
            LOG.warning(buf);
        }
    }
}

