/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceLoader;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CheckParameterizables {
    private static final Logging LOG = Logging.getLogger(CheckParameterizables.class);
    private List<Class<?>> knownParameterizables;

    public void checkParameterizables() {
        LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
        this.knownParameterizables = new ArrayList();
        try {
            Enumeration<URL> us = this.getClass().getClassLoader().getResources("META-INF/elki/");
            while (us.hasMoreElements()) {
                URL u = us.nextElement();
                if ("file".equals(u.getProtocol())) {
                    for (String prop : new File(u.toURI()).list()) {
                        try {
                            this.knownParameterizables.add(Class.forName(prop));
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warning("Service file name is not a class name: " + prop);
                        }
                    }
                    continue;
                }
                if (!"jar".equals(u.getProtocol())) continue;
                JarURLConnection con = (JarURLConnection)u.openConnection();
                JarFile jar = con.getJarFile();
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String prop = entries.nextElement().getName();
                        if (prop.startsWith("META-INF/elki/")) {
                            prop = prop.substring("META-INF/elki/".length());
                        } else {
                            if (!prop.startsWith(ELKIServiceLoader.FILENAME_PREFIX)) continue;
                            prop = prop.substring(ELKIServiceLoader.FILENAME_PREFIX.length());
                        }
                        try {
                            this.knownParameterizables.add(Class.forName(prop));
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warning("Service file name is not a class name: " + prop);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new AbortException("Error enumerating service folders.", e);
        }
        String internal = Parameterizer.class.getPackage().getName();
        for (Class<?> cls : ELKIServiceRegistry.findAllImplementations(Object.class, false, false)) {
            if (cls.getName().startsWith(internal)) continue;
            try {
                State state = State.NO_CONSTRUCTOR;
                if ((state = this.checkV3Parameterization(cls, state)) == State.ERROR || (state = this.checkDefaultConstructor(cls, state)) == State.ERROR) continue;
                boolean expectedParameterizer = this.checkSupertypes(cls);
                if (state == State.NO_CONSTRUCTOR && expectedParameterizer) {
                    LOG.verbose("Class " + cls.getName() + " implements a parameterizable interface, but doesn't have a public and parameterless constructor!");
                }
                if (state != State.INSTANTIABLE || expectedParameterizer) continue;
                LOG.verbose("Class " + cls.getName() + " has a parameterizer, but there is no service file for any of its interfaces.");
            }
            catch (NoClassDefFoundError e) {
                LOG.verbose("Class discovered but not found: " + cls.getName() + " (missing: " + e.getMessage() + ")");
            }
        }
    }

    private boolean checkSupertypes(Class<?> cls) {
        for (Class<?> c : this.knownParameterizables) {
            if (!c.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private State checkV3Parameterization(Class<?> cls, State state) throws NoClassDefFoundError {
        for (Class<?> inner : cls.getDeclaredClasses()) {
            if (!AbstractParameterizer.class.isAssignableFrom(inner)) continue;
            try {
                Class<AbstractParameterizer> pcls = inner.asSubclass(AbstractParameterizer.class);
                pcls.newInstance();
                if (!this.checkParameterizer(cls, pcls)) continue;
                if (state == State.INSTANTIABLE) {
                    LOG.warning("More than one parameterization method in class " + cls.getName());
                }
                state = State.INSTANTIABLE;
            }
            catch (Error | Exception e) {
                LOG.verbose("Could not run Parameterizer: " + inner.getName() + ": " + e.getMessage());
            }
        }
        return state;
    }

    private State checkDefaultConstructor(Class<?> cls, State state) throws NoClassDefFoundError {
        try {
            cls.getConstructor(new Class[0]);
            return State.DEFAULT_INSTANTIABLE;
        }
        catch (Exception exception) {
            return state;
        }
    }

    private boolean checkParameterizer(Class<?> cls, Class<? extends AbstractParameterizer> par) {
        int checkResult = 0;
        try {
            par.getConstructor(new Class[0]);
            Method[] methods = par.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method meth = methods[i];
                if (!meth.getName().equals("makeInstance")) continue;
                if (meth.getParameterTypes().length == 0) {
                    if (cls.isAssignableFrom(meth.getReturnType())) {
                        checkResult = 1;
                        continue;
                    }
                    if (checkResult != 0) continue;
                    checkResult = 2;
                    continue;
                }
                if (checkResult != 0) continue;
                checkResult += 3;
            }
        }
        catch (Exception e) {
            LOG.warning("No proper Parameterizer.makeInstance for " + cls.getName() + ": " + e);
            return false;
        }
        if (checkResult > 1) {
            LOG.warning("No proper Parameterizer.makeInstance for " + cls.getName() + " found!");
        }
        return checkResult == 1;
    }

    public static void main(String[] args) {
        new CheckParameterizables().checkParameterizables();
    }

    static enum State {
        NO_CONSTRUCTOR,
        INSTANTIABLE,
        DEFAULT_INSTANTIABLE,
        ERROR;

    }
}

