/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import java.util.regex.Pattern;

public class Bit
extends Number {
    private static final long serialVersionUID = 390879869314931240L;
    public static final Pattern BIT_PATTERN = Pattern.compile("^[01]$");
    public static final Bit TRUE = new Bit(true);
    public static final Bit FALSE = new Bit(false);
    private boolean bit;

    public static Bit valueOf(String bit) throws NumberFormatException {
        int i = ParseUtil.parseIntBase10(bit);
        if (i != 0 && i != 1) {
            throw new NumberFormatException("Input \"" + bit + "\" must be 0 or 1.");
        }
        return i > 0 ? TRUE : FALSE;
    }

    public static Bit valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Deprecated
    public Bit(boolean bit) {
        this.bit = bit;
    }

    @Deprecated
    public Bit(int bit) throws IllegalArgumentException {
        if (bit != 0 && bit != 1) {
            throw new IllegalArgumentException("Required: 0 or 1 - found: " + bit);
        }
        this.bit = bit == 1;
    }

    @Override
    public int intValue() {
        return this.bit ? 1 : 0;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public boolean bitValue() {
        return this.bit;
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }
}

