/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.Bit;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BitVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<BitVector> SHORT_SERIALIZER = new ShortSerializer();
    private final long[] bits;
    private int dimensionality;

    public BitVector(long[] bits, int dimensionality) {
        this.bits = bits;
        this.dimensionality = dimensionality;
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int dimensionality) {
        this.dimensionality = dimensionality;
    }

    public boolean booleanValue(int dimension) {
        return BitsUtil.get(this.bits, dimension);
    }

    @Override
    @Deprecated
    public Bit getValue(int dimension) {
        return new Bit(this.booleanValue(dimension));
    }

    @Override
    public double doubleValue(int dimension) {
        return BitsUtil.get(this.bits, dimension) ? 1.0 : 0.0;
    }

    @Override
    public long longValue(int dimension) {
        return BitsUtil.get(this.bits, dimension) ? 1L : 0L;
    }

    @Override
    public int iter() {
        return BitsUtil.nextSetBit(this.bits, 0);
    }

    @Override
    public int iterAdvance(int iter) {
        return BitsUtil.nextSetBit(this.bits, iter + 1);
    }

    @Override
    public int iterRetract(int iter) {
        return BitsUtil.previousSetBit(this.bits, iter - 1);
    }

    @Override
    public boolean iterValid(int iter) {
        return iter >= 0;
    }

    @Override
    public int iterDim(int iter) {
        return iter;
    }

    @Override
    public double iterDoubleValue(int iter) {
        return 1.0;
    }

    @Override
    public long iterLongValue(int iter) {
        return 1L;
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.dimensionality];
        int i = BitsUtil.nextSetBit(this.bits, 0);
        while (i >= 0) {
            data[i] = 1.0;
            i = BitsUtil.nextSetBit(this.bits, i + 1);
        }
        return data;
    }

    public boolean contains(long[] bitset) {
        for (int i = 0; i < bitset.length; ++i) {
            long b = bitset[i];
            if (i >= this.bits.length && b != 0L) {
                return false;
            }
            if ((b & this.bits[i]) == b) continue;
            return false;
        }
        return true;
    }

    public long[] cloneBits() {
        return (long[])this.bits.clone();
    }

    public int cardinality() {
        return BitsUtil.cardinality(this.bits);
    }

    public double jaccardSimilarity(BitVector v2) {
        return (double)BitsUtil.intersectionSize(this.bits, v2.bits) / (double)BitsUtil.unionSize(this.bits, v2.bits);
    }

    public int hammingDistance(BitVector v2) {
        return BitsUtil.hammingDistance(this.bits, v2.bits);
    }

    public int intersectionSize(BitVector v2) {
        return BitsUtil.intersectionSize(this.bits, v2.bits);
    }

    public int unionSize(BitVector v2) {
        return BitsUtil.unionSize(this.bits, v2.bits);
    }

    public boolean intersect(BitVector v2) {
        return BitsUtil.intersect(this.bits, v2.bits);
    }

    public void andOnto(long[] v) {
        BitsUtil.andI(v, this.bits);
    }

    public void orOnto(long[] v) {
        BitsUtil.orI(v, this.bits);
    }

    public void xorOnto(long[] v) {
        BitsUtil.xorI(v, this.bits);
    }

    @Override
    public String toString() {
        StringBuilder representation = new StringBuilder(this.dimensionality);
        for (int i = 0; i < this.dimensionality; ++i) {
            if (i > 0) {
                representation.append(" ");
            }
            representation.append(BitsUtil.get(this.bits, i) ? (char)'1' : '0');
        }
        return representation.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitVector) {
            BitVector bv = (BitVector)obj;
            return this.getDimensionality() == bv.getDimensionality() && Arrays.equals(this.bits, bv.bits);
        }
        return false;
    }

    public int hashCode() {
        return BitsUtil.hashCode(this.bits);
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<BitVector> {
        @Override
        public BitVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            int len = 2 + (dimensionality + 7) / 8;
            if (buffer.remaining() < len) {
                throw new IOException("Not enough data for a bit vector!");
            }
            long[] bits = BitsUtil.zero(dimensionality);
            byte b = 0;
            for (int i = 0; i < dimensionality; ++i) {
                byte bit;
                if ((i & 7) == 0) {
                    b = buffer.get();
                }
                if ((b & (bit = (byte)(1 << (i & 7)))) == 0) continue;
                BitsUtil.setI(bits, i);
            }
            return new BitVector(bits, dimensionality);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, BitVector vec) throws IOException {
            int len = this.getByteSize(vec);
            assert (vec.getDimensionality() <= Short.MAX_VALUE);
            int dim = vec.getDimensionality();
            if (buffer.remaining() < len) {
                throw new IOException("Not enough space for the bit vector!");
            }
            buffer.putShort((short)dim);
            byte b = 0;
            for (int i = 0; i < dim; ++i) {
                byte mask = (byte)(1 << (i & 7));
                b = BitsUtil.get(vec.bits, i) ? (byte)(b | mask) : (byte)(b & ~mask);
                if ((i & 7) != 7 && i != dim - 1) continue;
                buffer.put(b);
                b = 0;
            }
        }

        @Override
        public int getByteSize(BitVector vec) {
            return 2 + (vec.getDimensionality() + 7) / 8;
        }
    }

    public static class Factory
    implements SparseNumberVector.Factory<BitVector> {
        @Override
        public <A> BitVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            long[] bits = BitsUtil.zero(dim);
            for (int i = 0; i < dim; ++i) {
                if (!(adapter.get(array, i).doubleValue() >= 0.5)) continue;
                BitsUtil.setI(bits, i);
            }
            return new BitVector(bits, dim);
        }

        @Override
        public <A> BitVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            long[] bits = BitsUtil.zero(dim);
            for (int i = 0; i < dim; ++i) {
                if (!(adapter.getDouble(array, i) >= 0.5)) continue;
                BitsUtil.setI(bits, i);
            }
            return new BitVector(bits, dim);
        }

        @Override
        public BitVector newNumberVector(Int2DoubleOpenHashMap values, int maxdim) {
            long[] bits = BitsUtil.zero(maxdim);
            for (Int2DoubleMap.Entry entry : values.int2DoubleEntrySet()) {
                if (entry.getDoubleValue() == 0.0) continue;
                BitsUtil.setI(bits, entry.getIntKey());
            }
            return new BitVector(bits, maxdim);
        }

        @Override
        public ByteBufferSerializer<BitVector> getDefaultSerializer() {
            return SHORT_SERIALIZER;
        }

        @Override
        public Class<? super BitVector> getRestrictionClass() {
            return BitVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

