/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteVector
implements NumberVector {
    public static final Factory STATIC = new Factory();
    public static final ByteBufferSerializer<ByteVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<ByteVector> SHORT_SERIALIZER = new ShortSerializer();
    private final byte[] values;

    private ByteVector(byte[] values, boolean nocopy) {
        if (nocopy) {
            this.values = values;
        } else {
            this.values = new byte[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }
    }

    public ByteVector(byte[] values) {
        this.values = new byte[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Byte getValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public byte byteValue(int dimension) {
        return this.values[dimension];
    }

    public byte[] getValues() {
        byte[] copy = new byte[this.values.length];
        System.arraycopy(this.values, 0, copy, 0, this.values.length);
        return copy;
    }

    @Override
    public double[] toArray() {
        double[] data = new double[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            data[i] = this.values[i];
        }
        return data;
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            featureLine.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            featureLine.append(" ");
        }
        return featureLine.toString();
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<ByteVector> {
        @Override
        public ByteVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            assert (buffer.remaining() >= 1 * dimensionality);
            byte[] values = new byte[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.get();
            }
            return new ByteVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, ByteVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 1 * vec.values.length);
            buffer.putShort((short)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.put(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(ByteVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 1 * vec.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<ByteVector> {
        @Override
        public ByteVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.get();
            assert (buffer.remaining() >= 1 * dimensionality);
            byte[] values = new byte[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.get();
            }
            return new ByteVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, ByteVector vec) throws IOException {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (buffer.remaining() >= 1 * vec.values.length);
            buffer.put((byte)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.put(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(ByteVector vec) {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 1 * vec.getDimensionality();
        }
    }

    public static class Factory
    implements NumberVector.Factory<ByteVector> {
        @Override
        public <A> ByteVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            byte[] values = new byte[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).byteValue();
            }
            return new ByteVector(values, true);
        }

        @Override
        public <A> ByteVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            int dim = adapter.size(array);
            byte[] values = new byte[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getByte(array, i);
            }
            return new ByteVector(values, true);
        }

        @Override
        public ByteBufferSerializer<ByteVector> getDefaultSerializer() {
            return SHORT_SERIALIZER;
        }

        @Override
        public Class<? super ByteVector> getRestrictionClass() {
            return ByteVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

