/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.util.Comparator;

public class Cluster<M extends Model>
implements TextWriteable {
    protected String name = null;
    private DBIDs ids = null;
    private M model = null;
    private boolean noise = false;
    public static Comparator<Cluster<?>> BY_NAME_SORTER = new Comparator<Cluster<?>>(){

        @Override
        public int compare(Cluster<?> o1, Cluster<?> o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.name != o2.name) {
                if (o1.name == null) {
                    return 1;
                }
                if (o2.name == null) {
                    return -1;
                }
                int lblresult = o1.name.compareTo(o2.name);
                if (lblresult != 0) {
                    return lblresult;
                }
            }
            return 0;
        }
    };

    public Cluster(String name, DBIDs ids, boolean noise, M model) {
        this.name = name;
        this.ids = ids;
        this.noise = noise;
        this.model = model;
    }

    public Cluster(String name, DBIDs ids, M model) {
        this(name, ids, false, model);
    }

    public Cluster(DBIDs ids, boolean noise, M model) {
        this(null, ids, noise, model);
    }

    public Cluster(DBIDs ids, M model) {
        this(null, ids, false, model);
    }

    public Cluster(String name, DBIDs ids, boolean noise) {
        this(name, ids, noise, null);
    }

    public Cluster(String name, DBIDs ids) {
        this(name, ids, false, null);
    }

    public Cluster(DBIDs ids, boolean noise) {
        this(null, ids, noise, null);
    }

    public Cluster(DBIDs ids) {
        this(null, ids, false, null);
    }

    public int size() {
        return this.ids.size();
    }

    public String getNameAutomatic() {
        if (this.name != null) {
            return this.name;
        }
        if (this.isNoise()) {
            return "Noise";
        }
        return "Cluster";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DBIDs getIDs() {
        return this.ids;
    }

    public void setIDs(DBIDs g) {
        this.ids = g;
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
    }

    @Override
    public void writeToText(TextWriterStream out, String label) {
        String name = this.getNameAutomatic();
        if (name != null) {
            out.commentPrintLn("Cluster name: " + name);
        }
        out.commentPrintLn("Cluster noise flag: " + this.isNoise());
        out.commentPrintLn("Cluster size: " + this.ids.size());
        if (this.getModel() != null && this.getModel() instanceof TextWriteable) {
            ((TextWriteable)this.getModel()).writeToText(out, label);
        }
    }

    public boolean isNoise() {
        return this.noise;
    }

    public void setNoise(boolean noise) {
        this.noise = noise;
    }

    public String toString() {
        String mstr = this.model == null ? "null" : this.model.toString();
        String nstr = this.noise ? ",noise" : "";
        return "Cluster(size=" + this.size() + ",model=" + mstr + nstr + ")";
    }
}

