/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.ModifiableHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.IterableIt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Clustering<M extends Model>
extends BasicResult {
    public static final SimpleTypeInformation<Clustering<?>> TYPE = new SimpleTypeInformation<Clustering>(Clustering.class);
    private List<Cluster<M>> toplevelclusters;
    private ModifiableHierarchy<Cluster<M>> hierarchy;

    public Clustering(String name, String shortname, List<Cluster<M>> toplevelclusters) {
        super(name, shortname);
        this.toplevelclusters = toplevelclusters;
        this.hierarchy = new HashMapHierarchy<Cluster<M>>();
        for (Cluster<M> clus : toplevelclusters) {
            this.hierarchy.add(clus);
        }
    }

    public Clustering(String name, String shortname) {
        this(name, shortname, new ArrayList<Cluster<M>>());
    }

    public void addToplevelCluster(Cluster<M> clus) {
        this.toplevelclusters.add(clus);
        this.hierarchy.add(clus);
    }

    public void addChildCluster(Cluster<M> parent, Cluster<M> child) {
        this.hierarchy.add(parent, child);
    }

    public List<Cluster<M>> getToplevelClusters() {
        return this.toplevelclusters;
    }

    public Hierarchy<Cluster<M>> getClusterHierarchy() {
        return this.hierarchy;
    }

    public List<Cluster<M>> getAllClusters() {
        ArrayList<Cluster<M>> res = new ArrayList<Cluster<M>>(this.hierarchy.size());
        It iter = this.hierarchy.iterAll();
        while (iter.valid()) {
            res.add((Cluster<M>)iter.get());
            iter.advance();
        }
        Collections.sort(res, Cluster.BY_NAME_SORTER);
        return res;
    }

    public It<Cluster<M>> iterToplevelClusters() {
        return new IterableIt<Cluster<M>>(this.toplevelclusters);
    }

    public static List<Clustering<? extends Model>> getClusteringResults(Result r) {
        if (r instanceof Clustering) {
            ArrayList<Clustering<? extends Model>> crs = new ArrayList<Clustering<? extends Model>>(1);
            crs.add((Clustering)r);
            return crs;
        }
        if (r instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)r).getHierarchy(), r, Clustering.class);
        }
        return Collections.emptyList();
    }
}

