/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DoubleVector
implements NumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<DoubleVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<DoubleVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<DoubleVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final double[] values;

    private DoubleVector(double[] values, boolean nocopy) {
        this.values = nocopy ? values : (double[])values.clone();
    }

    public DoubleVector(double[] values) {
        this.values = (double[])values.clone();
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return (long)this.values[dimension];
    }

    @Override
    public double[] toArray() {
        return (double[])this.values.clone();
    }

    @Override
    public String toString() {
        StringBuilder featureLine = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            featureLine.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            featureLine.append(" ");
        }
        return featureLine.toString();
    }

    public static DoubleVector copy(double[] vals) {
        return new DoubleVector(vals);
    }

    public static DoubleVector wrap(double[] vals) {
        return new DoubleVector(vals, true);
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = ByteArrayUtil.readUnsignedVarint(buffer);
            assert (buffer.remaining() >= 8 * dimensionality) : "Not enough data remaining in buffer to read " + dimensionality + " doubles";
            double[] values = new double[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getDouble();
            }
            return new DoubleVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, DoubleVector vec) throws IOException {
            assert (buffer.remaining() >= 8 * vec.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(vec).length + " doubles";
            ByteArrayUtil.writeUnsignedVarint(buffer, vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putDouble(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector vec) {
            return ByteArrayUtil.getUnsignedVarintSize(vec.values.length) + 8 * vec.values.length;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.getShort();
            assert (buffer.remaining() >= 8 * dimensionality) : "Not enough data remaining in buffer to read " + dimensionality + " doubles";
            double[] values = new double[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getDouble();
            }
            return new DoubleVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, DoubleVector vec) throws IOException {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (buffer.remaining() >= 8 * vec.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(vec).length + " doubles";
            buffer.putShort((short)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putDouble(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector vec) {
            assert (vec.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 8 * vec.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<DoubleVector> {
        @Override
        public DoubleVector fromByteBuffer(ByteBuffer buffer) throws IOException {
            int dimensionality = buffer.get();
            assert (buffer.remaining() >= 8 * dimensionality) : "Not enough data remaining in buffer to read " + dimensionality + " doubles";
            double[] values = new double[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                values[i] = buffer.getDouble();
            }
            return new DoubleVector(values, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, DoubleVector vec) throws IOException {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (buffer.remaining() >= 8 * vec.values.length) : "Not enough space remaining in buffer to write " + DoubleVector.access$100(vec).length + " doubles";
            buffer.put((byte)vec.values.length);
            for (int i = 0; i < vec.values.length; ++i) {
                buffer.putDouble(vec.values[i]);
            }
        }

        @Override
        public int getByteSize(DoubleVector vec) {
            assert (vec.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 8 * vec.getDimensionality();
        }
    }

    public static class Factory
    implements NumberVector.Factory<DoubleVector> {
        @Override
        public DoubleVector newNumberVector(double[] values) {
            return new DoubleVector(values);
        }

        @Override
        public <A> DoubleVector newFeatureVector(A array, ArrayAdapter<? extends Number, A> adapter) {
            int dim = adapter.size(array);
            double[] values = new double[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.get(array, i).doubleValue();
            }
            return new DoubleVector(values, true);
        }

        @Override
        public <A> DoubleVector newNumberVector(A array, NumberArrayAdapter<?, ? super A> adapter) {
            if (adapter.getClass() == DoubleArray.class) {
                return new DoubleVector(((DoubleArray)array).toArray(), true);
            }
            int dim = adapter.size(array);
            double[] values = new double[dim];
            for (int i = 0; i < dim; ++i) {
                values[i] = adapter.getDouble(array, i);
            }
            return new DoubleVector(values, true);
        }

        @Override
        public ByteBufferSerializer<DoubleVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super DoubleVector> getRestrictionClass() {
            return DoubleVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

